from sklearn import cluster, tree


def run(args, X):
    # Create the KMeans to fit on the data
    kmeans_base = cluster.KMeans(n_clusters=args.n_clusters)
    kmeans_pred = kmeans_base.fit_predict(X)

    # Then
    clustering_tree = tree.DecisionTreeClassifier(max_depth=args.max_depth, max_leaf_nodes=args.max_leaves)
    clustering_tree.fit(X, kmeans_pred)
    tree_pred = clustering_tree.predict(X)

    return tree_pred, clustering_tree.tree_
