import numpy as np
import math
from proto.gym_rl_pb2 import OfflineRlInfo
from config.config_mahjong import Config
from algorithms.base.offline_rlinfo_adapter import OfflineRlInfoAdapter as Adapter
IS_CHECK = Config.IS_CHECK

class OfflineRlInfoAdapter(Adapter):

    def __init__(self):
        #super(Adapter, self).__init__()
        self.rl_info = OfflineRlInfo()

    def deserialization(self, receive_data):
        data = []
        self.rl_info.ParseFromString(receive_data)
        rl_info = self.rl_info

        feature = np.frombuffer(rl_info.feature, 'f4')
        action = np.array(rl_info.action_list).astype('float32')
        value = np.array([rl_info.value]).astype('float32')
        neg_log_pi = np.array([rl_info.neg_log_pis]).astype('float32')
        advantage = np.array([rl_info.advantage]).astype('float32')
        legal_action = np.array([rl_info.legal_action]).astype('bool')
        res =  np.concatenate([feature, advantage, action, neg_log_pi, value, legal_action[0]])
        data.append(res)

        if np.isnan(res).sum() != 0 or math.isnan(advantage) or math.isnan(neg_log_pi) or math.isnan(value):
            print (np.isnan(res), advantage, neg_log_pi, value)
            print ("data error!")

        if IS_CHECK:
            with open("./log/frame_{}.txt".format(str(rl_info.frame_no)), 'w') as f_out:
                f_out.write("frame_no: " + str(rl_info.frame_no) + "\n")
                f_out.write("feature: " + str(rl_info.feature) + "\n")
                f_out.write("advantage: " + str(format(advantage[0], '0.5f')) + "\n")
                f_out.write("action: " + str(action) + "\n")
                f_out.write("neg_log_pi: " + str(neg_log_pi[0]) + "\n")
                f_out.write("value: " + str(value[0]) + "\n")
        return data
