close all
clear
A1=[1,1,0;1,-2,1];
b1=ones(2,1);
A2=[1,0,1;1,1,-2];
b2=ones(2,1);

options = optimoptions('fmincon','ConstraintTolerance',1e-18,'OptimalityTolerance',1e-18,'Display','off');

% compute and display joint max margin, task1 max margin, task2 max margin
w0 = [0,0,0];
fun = @(w)(w(1))^2 + (w(2))^2 + (w(3))^2;
mmsol_j = fmincon(fun,w0,[-A1;-A2],[-b1;-b2],[],[],[],[],[],options)

w0 = [0,0,0];
fun = @(w)(w(1))^2 + (w(2))^2 + (w(3))^2;
mmsol_t1 = fmincon(fun,w0,-A1,-b1,[],[],[],[],[],options)

w0 = [0,0,0];
fun = @(w)(w(1))^2 + (w(2))^2 + (w(3))^2;
mmsol_t2 = fmincon(fun,w0,-A2,-b2,[],[],[],[],[],options)

% run SMM for 10 cycles
J = 10;
wtraj = zeros(1+2*J,3);
for t = 1:J
    fun = @(w)(w(1)-wtraj(2*t-1,1))^2 + (w(2)-wtraj(2*t-1,2))^2 + (w(3)-wtraj(2*t-1,3))^2;
    wtraj(2*t,:) = fmincon(fun,wtraj(2*t-1,:),-A1,-b1,[],[],[],[],[],options);

    fun = @(w)(w(1)-wtraj(2*t,1))^2 + (w(2)-wtraj(2*t,2))^2 + (w(3)-wtraj(2*t,3))^2;
    wtraj(2*t+1,:) = fmincon(fun,wtraj(2*t,:),-A2,-b2,[],[],[],[],[],options);
end

plot(0:2*J,wtraj(:,1),'r-',0:2*J,wtraj(:,2),'g-',0:2*J,wtraj(:,3),'b-','LineWidth',2);
legend('w1','w2','w3')
fontsize(20,"points")
xlabel("SMM Iterations (10 Cycles)")
ylabel("SMM Iterate Values")