import torch.nn as nn


class ShallowNet(nn.Module):
    def __init__(self, input_dim, hidden_dim, n_classes):
        super().__init__()
        self.net = nn.Sequential(
            nn.Linear(input_dim, hidden_dim),
            nn.ReLU(),
            nn.Linear(hidden_dim, n_classes),
        )

    def forward(self, x):
        return self.net(x)


class LinearModel(nn.Module):
    def __init__(self, input_dim, n_classes):
        super().__init__()
        self.net = nn.Linear(input_dim, n_classes)

    def forward(self, x):
        return self.net(x)
