#!/bin/bash

# Define constant parameters
CONFIG_PATH="/data/deepak/lat-diffusion/logs/2024-11-04T22-50-04_txt2img-diff-identity-prompts/checkpoints/config.yaml"
CKPT_PATH="/data/deepak/lat-diffusion/logs/2024-11-04T22-50-04_txt2img-diff-identity-prompts/checkpoints/best_21003.ckpt"

OUT_FOLDER_NAME="3000_ids_trained_novel_id"

SCALE=4.5
HEIGHT=768
N_SAMPLE=1

# Loop through identities 1 to 100
for IDENTITY in {3101..3200}; do
    # Set the prompt and concept prompt
    PROMPT="identity-$IDENTITY"
    CONCEPT_PROMPT=$IDENTITY

    # Run the txt2ti_identity.py script
    echo "Running txt2ti_identity.py for identity $IDENTITY"
    python scripts/txt2ti_identity.py \
        --config "$CONFIG_PATH" \
        --prompt "$PROMPT" \
        --ckpt "$CKPT_PATH" \
        --scale $SCALE \
        --H $HEIGHT \
        --n_sample $N_SAMPLE \
        --output_folder_name $OUT_FOLDER_NAME \
        --concept_prompt $CONCEPT_PROMPT

    # Define path for batch_textual_inversion_sd.py
    EMBEDDING_PATH="/data/deepak/diffusers/examples/textual_inversion/$OUT_FOLDER_NAME/identity-${IDENTITY}-prompts/diff_learned_embeds.safetensors"
    TOKEN="<id-${IDENTITY}>"

    # Run the batch_textual_inversion_sd.py script
    echo "Running sampling for identity $IDENTITY"
    python scripts/single_textual_inversion_sd_rv.py "$EMBEDDING_PATH" "$TOKEN" "novel_id" $OUT_FOLDER_NAME
done
