## Neighbor-aware Geodesic Transportation for Neighborhood Refinery

#### Description

This repository contains the core code, dataset and user guide for our proposed "Neighbor-aware Geodesic Transportation for Neighborhood Refinery".

#### Setup

To setup the environment, you can install all the required dependencies listed in the `requirements.txt` file by running the following command:

```
pip install -r requirements.txt
```

Specifically, we have tested the project with `torch` version 2.3, if you encounter any compilation issues while using your own environment, please strictly follow our dependencies.

#### Dataset

Download the image retrieval datasets such as ROxford5k from the official websites and use the pretrained models to extract image features. We have provided image features extracted by R-GeM, which can be found under `revisitop/dataset/roxford5k/features`.

#### CUDA code compilation

Navigate to the folder `reranker/geodesic_distance`, `reranker/matrix_utils` and `reranker/sparse_divergence`, run the following command in the terminal:

```
python setup.py build_ext --inplace
```

If the compilation completes without errors, you will see the complied files like `geodesic_distance.cpython-312-x86_64-linux-gnu.so` in the corresponding folders. These files can be imported as libraries in the project.

#### Experiment

Here we exhibit a demo of our proposed method. To reproduce the result reported in the paper, please run:

```
python main.py
```

You can obtain the following results. Note that we have also provided implementations of other methods.

```
>> roxford5k: mAP E: 84.39, M: 67.3, H: 44.24
>> roxford5k: mP@k[1, 5, 10] E: [97.06 91.76 87.04], M: [95.71 90.29 84.57], H: [87.14 69.71 59.86]
>> roxford5k: mAP E: 91.16, M: 81.09, H: 64.45
>> roxford5k: mP@k[1, 5, 10] E: [95.59 96.47 94.85], M: [92.86 94.   91.57], H: [92.86 86.   76.98]
```

