#include "include/utils.h"


torch::Tensor deepcopy(
    const torch::Tensor original_matrix,
    const torch::Tensor row_indexes,
    torch::Tensor target_matrix
){
    CHECK_INPUT(original_matrix);
    CHECK_INPUT(row_indexes);
    CHECK_INPUT(target_matrix);

    return deepcopy_cu(original_matrix, row_indexes, target_matrix);
}


PYBIND11_MODULE(TORCH_EXTENSION_NAME, m){
    m.def("deepcopy", &deepcopy);
}