This is the source code for the paper: How to Fine-Tune Your Foundation Models under Long-Tailed Distribution?

Dependencies are listed in [requirements.txt](requirements.txt).

### Reproduction

To reproduce the main result in the paper, please run
```bash
# run framework on CIFAR100-LT
python main.py  -d cifar100_ir100  -m clip_vit_b16_peft   num_epochs 50   augmentation None   classifier CosineClassifier    resampling squreroot    loss_type BS    label_smooth True

# run framework on ImageNet-LT
python main.py  -d imagenet_lt  -m clip_vit_b16_peft    num_epochs 50   augmentation None   classifier CosineClassifier    resampling squreroot    loss_type BS    label_smooth True

# run framework on Places-LT
python main.py  -d places_lt  -m clip_vit_b16_peft    num_epochs 50   augmentation None   classifier CosineClassifier    resampling squreroot    loss_type BS    label_smooth True

# run framework on iNaturalist 2018
python main.py  -d inat2018  -m clip_vit_b16_peft    num_epochs 50   augmentation None   classifier CosineClassifier    resampling squreroot    loss_type BS    label_smooth True
```


### Detailed Usage

To train and test the proposed method on more settings, run

```bash
python main.py -d [data] -m [model] [options]
```


The `[data]` can be the name of a .yaml file in [configs/data](configs/data), including `imagenet_lt`, `places_lt`, `inat2018`, `cifar100_ir100`, etc.

The `[model]` can be the name of a .yaml file in [configs/model](configs/model), including `clip_vit_b16_ft`, `clip_vit_b16_peft`, `in21k_vit_b16_ft`, `in21k_vit_b16_peft`etc.

`[options]` can facilitate modifying the configure options in [utils/config.py](utils/config.py).