import{_ as s,c as e,o as i,ag as t}from"./chunks/framework.B90TcSfW.js";const k=JSON.parse('{"title":"Spectral-Hub","description":"","frontmatter":{},"headers":[],"relativePath":"en/index.md","filePath":"en/index.md","lastUpdated":1751289591000}'),n={name:"en/index.md"};function l(r,a,p,h,o,d){return i(),e("div",null,a[0]||(a[0]=[t(`<h1 id="spectral-hub" tabindex="-1">Spectral-Hub <a class="header-anchor" href="#spectral-hub" aria-label="Permalink to &quot;Spectral-Hub&quot;">​</a></h1><p>An Excellent Toolkit for Spectral Benchmark.</p><h2 id="what-is-spectral-hub" tabindex="-1">What is Spectral-Hub? <a class="header-anchor" href="#what-is-spectral-hub" aria-label="Permalink to &quot;What is Spectral-Hub?&quot;">​</a></h2><p>Spectral-Hub is a comprehensive toolkit designed for chemical spectroscopy benchmark testing and model evaluation.</p><h2 id="key-features" tabindex="-1">Key Features <a class="header-anchor" href="#key-features" aria-label="Permalink to &quot;Key Features&quot;">​</a></h2><ul><li>🔬 <strong>Multiple Spectroscopy Types</strong>: Support for IR, Raman, NMR spectroscopy</li><li>🤖 <strong>Pre-trained Models</strong>: Ready-to-use models for various spectral analysis tasks</li><li>📊 <strong>Benchmark Suite</strong>: Standardized evaluation metrics and datasets</li><li>🚀 <strong>Easy to Use</strong>: Simple API for quick integration</li></ul><h2 id="quick-start" tabindex="-1">Quick Start <a class="header-anchor" href="#quick-start" aria-label="Permalink to &quot;Quick Start&quot;">​</a></h2><div class="language-python vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">python</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">import</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> spectral_hub </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">as</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> sh</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># Load a dataset</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">data </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> sh.load_dataset(</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&#39;ir_spectra&#39;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">)</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># Create and train a model</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">model </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> sh.SpectralModel()</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">model.train(data)</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># Evaluate performance</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">results </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> model.evaluate()</span></span></code></pre></div><h2 id="get-started" tabindex="-1">Get Started <a class="header-anchor" href="#get-started" aria-label="Permalink to &quot;Get Started&quot;">​</a></h2><ul><li><a href="/spectral-hub/en/tutorial">Tutorial</a> - Learn how to use Spectral-Hub</li><li><a href="/spectral-hub/en/api">API Reference</a> - Detailed API documentation</li><li><a href="/spectral-hub/en/benchmark">Benchmark</a> - View benchmark results and metrics</li></ul>`,10)]))}const u=s(n,[["render",l]]);export{k as __pageData,u as default};
