# Read Me

## Introduction
This is the official code repository for Winformer. 

The code is based on the framework of TimeDP and DiT, and we appreciate for the following repositories:

- [TimeDP: Learning to Generate Multi-Domain Time Series with Domain Prompts] https://github.com/microsoft/TimeCraft/tree/main/TimeDP

- [Scalable Diffusion Models with Transformers (DiT)] https://github.com/facebookresearch/DiT

## Quick Starts

### Requirements

```bash
conda env create -f environment.yml
```

### Data Preparation
- We utilize the benchmark the same as TimeDP, and the preprocessed datasets can be download [here](https://huggingface.co/datasets/YukhoW/TimeDP-Data/blob/main/TimeDP-Data.zip).
- Set `DATA_ROOT` environment variable to the path of the dataset, or manually modify the `data_path_dict` in `configs/multi_domain_winformer.yaml` to reflect the correct path.
- More detailed instruction can be found from the original repository of [TimeDP](https://github.com/microsoft/TimeCraft/tree/main/TimeDP).

### Usage

Training the winformer:
```bash
python main_train.py --base configs/multi_domain_impro_diff+DiT_def_ks.yaml --gpus 0, --logdir ./logs/ -sl 168 -up -nl 16 --batch_size 128 -lr 0.00005 -s 22 -deks 25 -kt avg_pool
```

- deks: The defined kernel size of the window-wise aligning, which is usually an odd number. e.g. 7, 13, 25
- kt: The kernel type of the window-wise aligning. We provide two options, namely dct_conv and avg_pool.
  - dct_conv: The kernel is implemented by convolutional neural network, which is initialized with the discrete cosine transform (DCT) basis.
  - avg_pool: The kernel is implemented by an average pooling operator.

# Acknowledgement
More details will be updated upon the acception of the paper.