from .clip import CLIP_model
from .idefics2 import Idefics2_model
from .llava import LLaVA_model
from .open_clip import OpenCLIP_model
from .utils import get_random_crop, to_tensor, to_pil



def load_model(**kwargs):
    model_id = kwargs["model_id"]
    if model_id.startswith("llava-hf/"):
        return LLaVA_model(**kwargs)
    elif model_id.startswith("openai/clip"):
        return CLIP_model(**kwargs)
    elif model_id.startswith("google/siglip"):
        return CLIP_model(**kwargs)
    elif model_id.startswith("open_clip/ViT"):
        return OpenCLIP_model(**kwargs)
    elif model_id == "HuggingFaceM4/idefics2-8b":
        return Idefics2_model(**kwargs)

