# VISTA - ICLR 2026
This is the code for our paper submission.

# Installation
```
conda create -n py310 python==3.10
pip install --upgrade pip
pip install gcastle numpy scipy torch pygam cdt igraph sfas
```
## Install dodiscover
```
git clone https://github.com/py-why/dodiscover.git
cd dodiscover
pip install -e .
```
# Run Baseline
To reproduce baseline results, run:
```
python baseline.py --model SCORE --nodes 100 --h 5 --type ER --method nonlinear --sem_type quadratic
```
This command generates an ER5 graph with 100 nodes and nonlinear quadratic noise, and applies the baseline solver SCORE.

# Run VISTA
To evaluate our VISTA framework, run:
```
python DC_FAS.py --model GOLEM --nodes 100 --h 5 --type SF --method linear --sem_type gauss
```
This command generates an SF5 graph with 100 nodes and linear Gaussian noise, and applies our proposed VISTA using GOLEM as the base learner.
