
from llava.data.encyclopedic_vqa_data import build_encyclopedic_vqa_data_modules
from llava.data.infoseek_data import build_infoseek_data_modules
from llava.data.viquae_data import build_viquae_data_modules
from llava.data.open_wikitable_data import build_open_wikitable_data_modules
from llava.data.encyclopedic_vqa_data_hard_neg import build_encyclopedic_vqa_hard_neg_data_modules

data_module_builders = {
    "encyclopedic_vqa": build_encyclopedic_vqa_data_modules,
    'encyclopedic_vqa_hard_neg': build_encyclopedic_vqa_hard_neg_data_modules,
    "infoseek": build_infoseek_data_modules,
    "viquae": build_viquae_data_modules,
    "open_wikitable": build_open_wikitable_data_modules,
    # add another dataset builders
}

def load_data_module(dataset_name):

    build_data_module_fn = data_module_builders.get(dataset_name)

    if build_data_module_fn is None:
        raise ValueError(f"No data module builder found for dataset: {dataset_name}")

    return build_data_module_fn