import argparse
import torch
import numpy as np
import os
import json
import glob
from tqdm import tqdm

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--mapping_path", type=str, default=".")
    args = parser.parse_args()
    
    mapping_files = sorted(glob.glob(args.mapping_path + '_[0-9]*.json'))

    # Note that the mapping function is accumulasted based on their only chunk.
    # Hence, we have to make them global when merging.
    mappings = dict()
    for mapping_file in mapping_files:
        mapping_i = json.load(open(mapping_file, 'r'))
        mappings.update(mapping_i)

    # Save the merged mapping dictionary
    with open(args.mapping_path + '.json', 'w') as f:
        json.dump(mappings, f)

    for mapping_file in mapping_files:
        os.remove(mapping_file)
