import argparse
import torch
import numpy as np
import os
import json
import glob

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--embed_path", type=str, default=".")
    args = parser.parse_args()

    embed_files = sorted(glob.glob(args.embed_path + '_[0-9]*.npy'))

    embeds = []
    for embed_file in embed_files:
        embeds.append(np.load(embed_file))

    embeds = np.concatenate(embeds)

    np.save(args.embed_path + '.npy', embeds)

    for embed_file in embed_files:
        os.remove(embed_file)