import argparse
import torch
import numpy as np
import os
import json
import glob

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--result_path", type=str, default=".")
    args = parser.parse_args()
    
    result_files = sorted(glob.glob(args.result_path + '_[0-9]*.json'))

    results = dict()
    for result_file in result_files:
        result_i = json.load(open(result_file, 'r'))
        results.update(result_i)

    # Save the merged result dictionary
    with open(args.result_path + '.json', 'w') as f:
        json.dump(results, f)

    for result_file in result_files:
        os.remove(result_file)
