import os

AVAILABLE_MODELS = {
    "llava_qwen_dual_ret": "LlavaQwenForCausalLMWithDualRet, LlavaQwenConfig",
    "llava_qwen_dual_rerank": "LlavaQwenForCausalLMWithDualReRank, LlavaQwenConfig",
    "llava_qwen_dual_rerank_interleaved": "LlavaQwenForCausalLMWithDualReRankInterleaved, LlavaQwenConfig",
    "llava_qwen_dual_rerank_random_neg": "LlavaQwenForCausalLMWithDualReRankRandomNeg, LlavaQwenConfig",
    # Add other models as needed
}

for model_name, model_classes in AVAILABLE_MODELS.items():
    try:
        exec(f"from .language_model.{model_name} import {model_classes}")
    except ImportError:
        # import traceback
        # traceback.print_exc()
        print(f"Failed to import {model_name} from llava.language_model.{model_name}")
        pass
