#!/bin/bash

gpu_list="${CUDA_VISIBLE_DEVICES:-0}"
IFS=',' read -ra GPULIST <<< "$gpu_list"

CHUNKS=${#GPULIST[@]}

RERANKER_MODEL=$1

if [ "$2" == "" ]; then
  BASE=llava-next-interleave-qwen-0.5b
else
  BASE=$2
fi

BASE_PATH=''

for IDX in $(seq 0 $((CHUNKS-1))); do
    CUDA_VISIBLE_DEVICES=${GPULIST[$IDX]} python llava/eval/encyclopedic_vqa/score_sec_encyclopedic_vqa.py \
        --model-path ${BASE_PATH}/checkpoints/${RERANKER_MODEL}_rerank \
        --model-base ${BASE_PATH}/checkpoints/$BASE \
        --conv qwen_1_5 \
        --document_path ${BASE_PATH}/dataset/encyclopedic_vqa/encyclopedic_kb_wiki/encyclopedic_kb_wiki_cleaned_table_test.json \
        --image_url_to_id_path ${BASE_PATH}/dataset/encyclopedic_vqa/encyclopedic_kb_wiki/image_url_to_id.json \
        --doc_use_image \
        --doc_use_table \
        --query_path ${BASE_PATH}/dataset/encyclopedic_vqa/test_clean.csv \
        --dataset_id_to_path ${BASE_PATH}/dataset/encyclopedic_vqa/dataset_id_to_path.json \
        --image_folder ${BASE_PATH}/dataset/encyclopedic_vqa \
        --is_multimodal \
        --image_aspect_ratio pad \
        --batch_size 16 \
        --num-chunks $CHUNKS \
        --chunk-idx $IDX \
        --document_top_k 25 \
        --ret_result_path ${BASE_PATH}/dataset/encyclopedic_vqa/results/encyc_text_q_interleaved_doc/document_retrieval_result.json \
        --rerank_result_save_path ${BASE_PATH}/dataset/encyclopedic_vqa/results/${RERANKER_MODEL}/section_rerank_result \

done

wait

python llava/eval/merge_results.py \
    --result_path ${BASE_PATH}/dataset/encyclopedic_vqa/results/${RERANKER_MODEL}/section_rerank_result \

python llava/eval/rerank.py \
    --query_path ${BASE_PATH}/dataset/encyclopedic_vqa/test_clean.csv \
    --rerank_result_path ${BASE_PATH}/dataset/encyclopedic_vqa/results/${RERANKER_MODEL}/section_rerank_result.json \
    --rerank_score_save_path ${BASE_PATH}/dataset/encyclopedic_vqa/results/${RERANKER_MODEL}/section_rerank_score.json \
