#!/bin/bash

BASE_PATH=''

deepspeed llava/train/train_retriever_mem.py \
    --lora_enable True --lora_r 32 --lora_alpha 64 \
    --deepspeed ${BASE_PATH}/Multimodal-Retrieval/scripts/zero2.json \
    --model_name_or_path ${BASE_PATH}/checkpoints/encyc_text_q_interleaved_doc_retrieve_merged \
    --doc_model_init False \
    --dataset_name viquae \
    --version qwen_1_5 \
    --train_query_path ${BASE_PATH}/dataset/viquae/train_clean.csv \
    --eval_query_path ${BASE_PATH}/dataset/viquae/validation_clean.csv \
    --document_path ${BASE_PATH}/dataset/viquae/viquae_wikipedia/viquae_kb_wiki_train_val.json \
    --image_url_to_id_path ${BASE_PATH}/dataset/viquae/viquae_wikipedia/image_url_to_id.json \
    --is_multimodal True \
    --image_folder ${BASE_PATH}/dataset/viquae/viquae_images/images \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --image_aspect_ratio pad \
    --bf16 True \
    --output_dir ${BASE_PATH}/checkpoints/viquae_text_q_interleaved_doc_retrieve \
    --num_train_epochs 4 \
    --per_device_train_batch_size 16 \
    --per_device_eval_batch_size 16 \
    --gradient_accumulation_steps 1 \
    --eval_accumulation_steps 1 \
    --eval_steps 50 \
    --evaluation_strategy steps \
    --save_strategy steps \
    --save_steps 50000 \
    --save_total_limit 1 \
    --learning_rate 2e-5 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type cosine \
    --logging_steps 5 \
    --tf32 True \
    --fp16 False \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 15 \
    --report_to wandb \
    --run_name viquae_text_q_interleaved_doc_retrieve \
    --inter_contrastive True \
    --intra_contrastive False \
    --query_use_image False \
    --doc_use_image True \
    --doc_use_table True \
    --mixed_query_modality False \
