import copy
import os
import json
import pandas as pd
import random

base_path = ''

# For fast evaluation of retrieval performance with test dataset, we extract randomly extract 100k KB that contains test dataset entities.
if __name__ == '__main__':

    train_query_df = pd.read_csv(os.path.join(base_path, 'train_clean.csv'))
    val_query_df = pd.read_csv(os.path.join(base_path, 'valid_clean.csv'))
    query_df = pd.concat([train_query_df, val_query_df])

    document_kb = json.load(open(os.path.join(base_path, 'openwikitable_wikipedia/openwikitable_kb_wiki.json'), 'r'))

    subset_doc_kb = {}
    for query in query_df.itertuples(index=False):
        subset_doc_kb[query.wikipedia_url] = copy.deepcopy(document_kb[query.wikipedia_url])

    with open(os.path.join(base_path, 'openwikitable_wikipedia/openwikitable_kb_wiki_train_val.json'), 'w') as f:
        json.dump(subset_doc_kb, f)
