# plot_config_utils.py

import matplotlib.pyplot as plt
import copy

# --- Base Colors ---
BASE_COLORS = {
    'blue': '#0173B2',
    'orange': '#DE8F05',
    'green': '#029E73',
    'red': '#D55E00',
    'purple': '#CC78BC',
    'gray': '#555555',
    'light_gray': '#CCCCCC',
    'unknown_norm': '#7F7F7F', # For nc_plot.py, can be ignored by others
    'black': '#000000',
    'white': '#FFFFFF',
}

# --- Base Default Plot Style Configuration ---
# Contains common elements. Script-specific additions will be merged in each script.
BASE_DEFAULT_PLOT_STYLE_CONFIG = {
    'figure_size_per_subplot': (12, 8),  # User value
    'plot_linewidth': 6,  # User value
    'axes_linewidth': 4,  # User value
    'grid_linewidth': 1.5,  # User value
    'grid_linestyle': '--',  # User value (same as before)
    'grid_alpha': 0.5,  # User value (same as before)
    'fill_alpha': 0.2,  # User value (same as before)

    'title_fontsize': 60,  # User value
    'axis_label_fontsize': 60,  # User value
    'tick_label_fontsize': 50,  # User value

    'legend_fontsize': 40,  # User value
    'legend_title_fontsize': 40,  # User value
    'legend_shadow': True,  # User value (same as before)
    'legend_frameon': True,  # User value (same as before)
    'legend_fancybox': True,  # User value (same as before)
    'legend_facecolor': BASE_COLORS['white'],  # User value
    'legend_edgecolor': BASE_COLORS['black'],  # User value
    'legend_frame_linewidth': 4.0,  # User value

    'tight_layout_pad': 1.5,
    'save_dpi': 600,
    'save_facecolor': BASE_COLORS['white'],

    'font_settings': {
        'family': 'sans-serif',
        'sans-serif': ['Arial', 'Helvetica', 'DejaVu Sans'],
        'serif': ['Times New Roman', 'Georgia', 'DejaVu Serif'],
        'monospace': ['Courier New', 'DejaVu Sans Mono'],
        'mathtext_fontset': 'stix'
    }
}

def _apply_font_settings(font_config):
    """Helper function to apply font settings from config."""
    try:
        plt.rcParams['font.family'] = font_config.get('family', 'sans-serif')
        if 'sans-serif' in font_config:
            plt.rcParams['font.sans-serif'] = font_config['sans-serif']
        if 'serif' in font_config:
            plt.rcParams['font.serif'] = font_config['serif']
        if 'monospace' in font_config:
            plt.rcParams['font.monospace'] = font_config['monospace']
        plt.rcParams['mathtext.fontset'] = font_config.get('mathtext_fontset', 'stix')
    except Exception as e:
        print(f"Warning: Could not apply some font settings: {e}")

def deep_update_style_config(base_config, overrides):
    """
    Deeply updates a base configuration dictionary with overrides.
    Modifies base_config in place.
    """
    for key, value in overrides.items():
        if isinstance(value, dict) and key in base_config and isinstance(base_config[key], dict):
            deep_update_style_config(base_config[key], value) # Recurse for nested dicts
        else:
            base_config[key] = value
    return base_config