
#### Variables that you should set before running the script
# this_path=$(cd "$(dirname "$0")";pwd)
# cd $this_path
# cd ..
export ROOT_PATH=$ADB_PROJECT_ROOT/scripts
cd $ROOT_PATH



source activate $ADB_ENV_NAME
export PYTHONPATH="$ADB_ENV_NAME:$PYTHONPATH"

export wandb_entity_name=
# for reproducibility
export seed=0

############### DATA 
# dataset_name=VGGFace2-clean

IFS=',' read -r -a dataset_names <<< "$DATASETS"
for dataset_name in "${dataset_names[@]}"; do
# for dataset_name in VGGFace2-clean ; do
# from 0 to 49
if [ "$dataset_name" = "VGGFace2-clean" ]; then
  # 0 1 7 48
  # instance_names=""
  # instance_names="0 1 48"
  # instance_names="0 48"
  instance_names="0 1 7 48"

fi
# based on INSTANCE_LIMIT, modify the instance_names
if [ "$INSTANCE_LIMIT" -gt 0 ]; then
  instance_names=$(echo $instance_names | tr ' ' '\n' | head -n $INSTANCE_LIMIT | tr '\n' ' ')
fi

# for defense_policy in none ; do 
# for NegTok in True False ; do
# export inputNegTok=$NegTok
# export outputNeg=$NegTok
for IONegTok in True False ; do
# for outputNeg in True; do 
export inputNegTok=$IONegTok
export outputNeg=$IONegTok
# for lora_rank in 2 4 8 16 32; do 
# none oracle
# for defense_policy in none code-sr oracle code sr anticode-code-sr anticode-code anticode-sr ; do 
# for defense_policy in none code-sr oracle anticode-code-sr anticode-code anticode-sr ; do 
# anticode-code anticode-sr 
# anticode-code-sr anticode-sr-code-sr
# anticode-sr-code-sr
# anticode-sr-codenocrop-sr
# for defense_policy in code-sr ; do 
for defense_policy in sr-code; do 
# for defense_policy in anticode-code-sr ; do 
# for defense_policy in anticode-sr-code anticode-sr-code-sr anticode-sr-code-sr ; do 
# for defense_policy in none code-sr oracle anticode-code-sr ; do 
# for defense_policy in none gau-code gau-sr gau-tvm gau-impress gau-diffpure oracle code sr tvm impress diffpure; do 
# for defense_policy in none gau-code gau-sr gau-tvm gau-impress gau-diffpure oracle code sr tvm impress diffpure ; do 

for instance_name in $instance_names; do

export dataset_name=$dataset_name
export instance_name=$instance_name
export CLEAN_TRAIN_DIR="$ADB_PROJECT_ROOT/dataset/$dataset_name/${instance_name}/set_A" 
export CLEAN_ADV_DIR="$ADB_PROJECT_ROOT/dataset/$dataset_name/${instance_name}/set_B"
export CLEAN_REF="$ADB_PROJECT_ROOT/dataset/$dataset_name/${instance_name}/set_C"
export class_name=$(cat $ADB_PROJECT_ROOT/dataset/$dataset_name/${instance_name}/class.txt)
# if class_name = "face", replace it with "person"
if [ "$class_name" = "face" ]; then
  class_name="person"
  # class_name="human face"
fi
# echo $class_name
# replace blank in class_name with -
class_name=$(echo $class_name | sed "s/ /-/g")
export class_name=$class_name
########## 


############### ATTACK
# method=aspl
# for method in aspl diffshortcut easpl fsmg; do
IFS=',' read -r -a method_zoo <<< "$METHODS"
for method in "${method_zoo[@]}"; do
# for method in aspl diffshortcut easpl fsmg; do

export gen_prompt=sks # the prompt used to craft the noise
# for other models, change the name and path correspondingly
# SD21, SD21base, SD15, SD14
export gen_model_name=SD21base # the model to generate the noise 
export MODEL_ROOT=$ADB_PROJECT_ROOT
export gen_model_path=$MODEL_ROOT/SD/stable-diffusion-2-1-base
export round=final # which round of noise to use for evaluation
export method_select=$method
r=11
export r=$r
# for later usage 
. ./methods_config.sh
export step_size=$(echo "scale=2; $r/10" | bc); 
export model_name=$gen_model_name
########## 


############### DEFENSE
# export defense_policy="gau-code"
# export train_defense_policy='inputneg-outputneg'
# export inputNegTok=True
# export outputNeg=False
# export noise_prompts=('UNKNOWN degraded quality' 'degraded quality' 'UNKNOWN artifact mask' 'artifact mask'  'UNKNOWN artifact' 'artifact' 'face degradation' 'UNKNOWN face degradation' 'corrupted simulated image' 'UNKNOWN corrupted simulated image')
# for index in "${!noise_prompts[@]}"; do
#     export noise_prompt="${noise_prompts[$index]}"
# index='_best'
if [ "$class_name" = "person" ]; then
noise_prompt='UNKNOWN face degradation'
else
noise_prompt='UNKNOWN noise corruption'
fi

# export es=True 
for es in False; do
export es_steps=300;
export es_metric=mix
export es_steps=$es_steps
export es_metric=$es_metric

for lr_scheduler in constant ; do
export lr_scheduler=$lr_scheduler
lr_scheduler_index=0
if [ "$lr_scheduler" = "cosine_with_restarts" ]; then
  lr_scheduler_index=1
fi

train_policy=''
if [ "$inputNegTok" = "True" ]; then
  train_policy=inN
fi
if [ "$outputNeg" = "True" ]; then
  train_policy=$train_policy-outN
fi
if [ "$es" = "True" ]; then
  train_policy=$train_policy-es
fi

export train_policy=$train_policy-lr-$lr_scheduler_index


############### TRAINING
export ft_type=full
export save_model=False 
# export lr_scheduler=cosine_with_restarts
export CLASS_DIR="$ADB_PROJECT_ROOT/prior-data/$model_name/class-$class_name"
# eval_prompts=( bhi mup hou )

export eval_prompt=sks # the prompt used to do dreambooth training
export eval_model_name=SD21base # the model that performs the evaluation on noise 
export eval_model_path=$MODEL_ROOT/SD/stable-diffusion-2-1-base
export eval_prompts=$(head -n 2 $ADB_PROJECT_ROOT/dataset/$dataset_name/${instance_name}/prompts.txt | tr '\n' ';' | sed "s/@@@/$eval_prompt/g")

export instance_prompt="a photo of $eval_prompt $class_name"
export id_prompt="a photo of $eval_prompt"
# export noise_prompt="noisy artifact background"
# export noise_prompt="noisy artifact background"
# for noise_prompt in "noisy artifact at background" "artifact at background" "noisy background" 'artifact mask'; do
# export noise_prompts=('noisy background' 'artifact mask' 'noisy artifact at background' 'artifact at background')
# for index in "${!noise_prompts[@]}"; do
#     noise_prompt="${noise_prompts[$index]}"
# export noise_prompts=('noisy background' 'noisy artifact mask' 'noisy artifact' )

# export index=0;
# export noise_prompt='noisy background'
if [ "$es" = "True" ]; then
  export validation_prompt="$instance_prompt"
  # export validation_prompt="$instance_prompt;$noise_prompt;$id_prompt"
  export validation_steps=50
else 
  export validation_prompt="$instance_prompt;$noise_prompt;$id_prompt"
  export validation_steps=9999
fi
export checkpointing_steps=9999
export validation_sample_steps=100
export num_validation_images=8


if [ "$ft_type" = "full" ]; then
  export lr=5e-7
  export max_train_steps=1000
# export max_train_steps=500
  # export lr_scheduler=cosine_with_restarts
  # export lr_scheduler=constant
elif [  "$ft_type" = "lora" ]; then
  export lr=1e-4
  export max_train_steps=500
  export lr_scheduler=constant
  export lora_rank=4
fi

export MODEL_PATH=$eval_model_path

########## 


############### SCORING

export eval_gen_img_num=16 # the number of images to generate per prompt 

########## 

# LOGGING MAN CONFIG
export prefix_name_gen=release
export prefix_name_train=$EXP_NAME
export score_exp_name=$prefix_name_train
export control_variables=$method-$defense_policy-$train_policy-$ft_type

#############

############### LOGGING AUTOCONFIG
export gen_exp_name_prefix=$prefix_name_gen
export method_hyper_name=$method_name-$method_hyper
export gen_exp_name=$gen_exp_name_prefix-$method_hyper_name
export train_exp_name=$prefix_name_train
export gen_exp_hyper=dataset-$dataset_name-r-$r-model-$gen_model_name-gen_prompt-$gen_prompt
export train_hyper=gen-$gen_exp_name-$gen_exp_hyper-eval-$control_variables

export OUTPUT_DIR="$ADB_PROJECT_ROOT/exp_data/gen_output/${gen_exp_name}/$gen_exp_hyper/${instance_name}"
export INSTANCE_DIR=$OUTPUT_DIR/noise-ckpt/${round}
export CLEAN_INSTANCE_DIR=$OUTPUT_DIR/image_before_addding_noise/
export INSTANCE_DIR_CHECK=$INSTANCE_DIR


export score_exp_config=$train_hyper
export note=$control_variables


# attacking
(cd $ROOT_PATH && . ./sub/attack/$gen_file_name && cd $ROOT_PATH && . ./sub/defense/controller.sh && cd $ROOT_PATH && . ./sub/train/$ft_type.sh && cd $ROOT_PATH && . ./sub/eval/eval.sh)

# sleep 45

done
done
done

done 
done 
done 
done 