
#### Variables that you should set before running the script
# this_path=$(cd "$(dirname "$0")";pwd)
# cd $this_path
# cd ..
export ROOT_PATH="$ADB_PROJECT_ROOT/scripts"
cd $ROOT_PATH



source activate $ADB_ENV_NAME
export PYTHONPATH="$ADB_ENV_NAME:$PYTHONPATH"

export wandb_entity_name=
# for reproducibility
export seed=0

############### DATA 
IFS=',' read -r -a dataset_names <<< "$DATASETS"
for dataset_name in "${dataset_names[@]}"; do
# from 0 to 49
if [ "$dataset_name" = "VGGFace2-clean" ]; then
  # 0 1 7 48
  # instance_names=""
  # instance_names="0 1 48"
  # instance_names="0 48"
  instance_names="0 1 7 48"

fi

# based on INSTANCE_LIMIT, modify the instance_names
if [ "$INSTANCE_LIMIT" -gt 0 ]; then
  instance_names=$(echo $instance_names | tr ' ' '\n' | head -n $INSTANCE_LIMIT | tr '\n' ' ')
fi


for inputNegTok in False ; do
for outputNeg in False; do 
export inputNegTok=$inputNegTok
export outputNeg=$outputNeg
for defense_policy in none oracle impress ldiffp eldiffp gridpure pdiffp tvm jpeg gau ddspure; do 

for instance_name in $instance_names; do

export dataset_name=$dataset_name
export instance_name=$instance_name
export CLEAN_TRAIN_DIR="$ADB_PROJECT_ROOT/dataset/$dataset_name/${instance_name}/set_A" 
export CLEAN_ADV_DIR="$ADB_PROJECT_ROOT/dataset/$dataset_name/${instance_name}/set_B"
export CLEAN_REF="$ADB_PROJECT_ROOT/dataset/$dataset_name/${instance_name}/set_C"
export class_name=$(cat $ADB_PROJECT_ROOT/dataset/$dataset_name/${instance_name}/class.txt)
# if class_name = "face", replace it with "person"
if [ "$class_name" = "face" ]; then
  class_name="person"
  # class_name="human face"
fi
# echo $class_name
# replace blank in class_name with -
class_name=$(echo $class_name | sed "s/ /-/g")
export class_name=$class_name
########## 


############### ATTACK
# method=aspl
# method=diffshortcut
# for method in diffshortcut aspl easpl fsmg advdm photoguard glaze; do
IFS=',' read -r -a method_zoo <<< "$METHODS"
for method in "${method_zoo[@]}"; do
echo $method
# for method in diffshortcut; do
export gen_prompt=sks # the prompt used to craft the noise
# for other models, change the name and path correspondingly
# SD21, SD21base, SD15, SD14
export gen_model_name=SD21base # the model to generate the noise 
export MODEL_ROOT=$ADB_PROJECT_ROOT
export gen_model_path=$MODEL_ROOT/SD/stable-diffusion-2-1-base
export round=final # which round of noise to use for evaluation
export method_select=$method
r=11
export r=$r
# for later usage 
. ./methods_config.sh
export step_size=$(echo "scale=2; $r/10" | bc); 
export model_name=$gen_model_name
########## 


############### DEFENSE
export index='_best'
export noise_prompt='UNKNOWN face degradation'


train_policy=''
if [ "$inputNegTok" = "True" ]; then
  train_policy=inputNegTok
fi
if [ "$outputNeg" = "True" ]; then
  train_policy=$train_policy-outputNeg
fi
export train_policy=$train_policy

########## 



############### TRAINING
export ft_type=full
export save_model=False 
export CLASS_DIR="$ADB_PROJECT_ROOT/prior-data/$model_name/class-$class_name"
# eval_prompts=( bhi mup hou )

export eval_prompt=sks # the prompt used to do dreambooth training
export eval_model_name=SD21base # the model that performs the evaluation on noise 
export eval_model_path=$MODEL_ROOT/SD/stable-diffusion-2-1-base
export eval_prompts=$(head -n 2 $ADB_PROJECT_ROOT/dataset/$dataset_name/${instance_name}/prompts.txt | tr '\n' ';' | sed "s/@@@/$eval_prompt/g")

export instance_prompt="a photo of $eval_prompt $class_name"
export id_prompt="a photo of $eval_prompt"
export validation_prompt="$instance_prompt;$noise_prompt;$id_prompt"

export validation_steps=9999
export checkpointing_steps=9999
export validation_sample_steps=100
export num_validation_images=8

if [ "$ft_type" = "full" ]; then
  export lr=5e-7
  export max_train_steps=1000
# export max_train_steps=500
  # export lr_scheduler=cosine_with_restarts
  export lr_scheduler=constant
elif [  "$ft_type" = "lora" ]; then
  export lr=1e-4
  export max_train_steps=500
  export lr_scheduler=constant
  export lora_rank=4
fi

export MODEL_PATH=$eval_model_path

########## 


############### SCORING

export eval_gen_img_num=16 # the number of images to generate per prompt 

########## 

# LOGGING MAN CONFIG
export prefix_name_gen=release
export prefix_name_train=$EXP_NAME
export score_exp_name=$prefix_name_train
export control_variables=$method-$defense_policy-$ft_type

#############

############### LOGGING AUTOCONFIG
export gen_exp_name_prefix=$prefix_name_gen
export method_hyper_name=$method_name-$method_hyper
export gen_exp_name=$gen_exp_name_prefix-$method_hyper_name
export train_exp_name=$prefix_name_train
export gen_exp_hyper=dataset-$dataset_name-r-$r-model-$gen_model_name-gen_prompt-$gen_prompt
export train_hyper=gen-$gen_exp_name-$gen_exp_hyper-eval-$control_variables

export OUTPUT_DIR="$ADB_PROJECT_ROOT/exp_data/gen_output/${gen_exp_name}/$gen_exp_hyper/${instance_name}"
export INSTANCE_DIR=$OUTPUT_DIR/noise-ckpt/${round}
export CLEAN_INSTANCE_DIR=$OUTPUT_DIR/image_before_addding_noise/
export INSTANCE_DIR_CHECK=$INSTANCE_DIR


export score_exp_config=$train_hyper
export note=$control_variables


# attacking
(cd $ROOT_PATH && . ./sub/attack/$gen_file_name && cd $ROOT_PATH && . ./sub/defense/controller.sh && cd $ROOT_PATH && . ./sub/train/$ft_type.sh && cd $ROOT_PATH && . ./sub/eval/eval.sh)

# sleep 45

done
done
done
done 
done 
done 