
dir_of_this_file="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
source $dir_of_this_file/generic.sh

###### the following are method-related variables ######
# alg_file_name="rem"
round=final
INSTANCE_DIR_CHECK="$OUTPUT_DIR/noise-ckpt/${round}"
eps=$(echo "scale=3; $r/255" | bc)
pgd_alpha=$(echo "scale=3; $step_size/255" | bc)


source activate $ADB_ENV_NAME
cd $ADB_PROJECT_ROOT/diffshortcut

if [ ! -d "$INSTANCE_DIR_CHECK" ]; then 
  {
  python3 attacks/algs/aspl.py \
    --pretrained_model_name_or_path=$MODEL_PATH  \
    --enable_xformers_memory_efficient_attention \
    --instance_data_dir_for_train=$CLEAN_TRAIN_DIR \
    --instance_data_dir_for_adversarial=$CLEAN_ADV_DIR \
    --instance_prompt="a photo of $gen_prompt $class_name" \
    --class_data_dir=$CLASS_DIR \
    --num_class_images=200 \
    --class_prompt="a photo of $class_name" \
    --output_dir=$OUTPUT_DIR \
    --center_crop \
    --with_prior_preservation \
    --prior_loss_weight=1.0 \
    --resolution=512 \
    --train_text_encoder \
    --train_batch_size=1 \
    --max_train_steps=50 \
    --max_f_train_steps=3 \
    --max_adv_train_steps=6 \
    --checkpointing_iterations=10 \
    --learning_rate=5e-7 \
    --pgd_alpha=$pgd_alpha \
    --pgd_eps=$eps \
    --mixed_precision=fp16 ;

  }
else
  echo "instance dir exists"
fi; 



# python3 attacks/algs/$alg_file_name.py --instance_name $instance_name --dataset_name $dataset_name \
    #   --defense_pgd_radius=$r \
    #   --defense_pgd_step_size=$step_size \
    #   --defense_pgd_step_num=6 \
    #   --defense_sample_num 1 \
    #   --defense_pgd_ascending \
    #   --original_flow \
    #   --exp_name $gen_exp_name \
    #   --exp_hyper $gen_exp_hyper \
    #   --pretrained_model_name_or_path=$MODEL_PATH  \
    #   --enable_xformers_memory_efficient_attention \
    #   --instance_data_dir_for_train=$CLEAN_TRAIN_DIR \
    #   --instance_data_dir_for_adversarial=$CLEAN_ADV_DIR \
    #   --instance_prompt="a photo of $gen_prompt $class_name" \
    #   --class_data_dir=$CLASS_DIR \
    #   --num_class_images=200 \
    #   --class_prompt="a photo of $class_name" \
    #   --output_dir=$OUTPUT_DIR \
    #   --center_crop \
    #   --with_prior_preservation \
    #   --prior_loss_weight=1.0 \
    #   --resolution=512 \
    #   --train_text_encoder \
    #   --train_batch_size=1 \
    #   --max_train_steps=50 \
    #   --max_f_train_steps=3 \
    #   --checkpointing_iterations=10 \
    #   --learning_rate=5e-7 \
    #   --mixed_precision=fp16 ;
