# Rethinking and Defending Protective Perturbation in Personalized Diffusion Models

> This is an official code implementation of the paper "Rethinking and Defending Protective Perturbation in Personalized Diffusion Models" 


## Environment Setup 
- setup the following environment variables 
```shell
# your project root
export ADB_PROJECT_ROOT="/path/to/your/project/root"
# your conda env name
export PYTHONPATH=$PYTHONPATH$:$ADB_PROJECT_ROOT
# install codeformer and set its python env path
export CodeFormer_PYTHON_ENV="YOUR_CONDA_ENV_NAME_FOR_CODEFORMER/python"
# install guided diffusion package (https://github.com/openai/guided-diffusion) and set its python env path
export GDiff_ENV_PYTHON_PATH="YOUR_CONDA_ENV_NAME_FOR_GDIFF/python"
```

## Software Dependencies
```shell
# python and pytorch, tested under python 3.9.18 and pytorch 1.13.1
conda create -n diffshortcut python=3.9.18
conda install pytorch==1.13.1 torchvision==0.14.1 torchaudio==0.13.1 pytorch-cuda=11.6 -c pytorch -c nvidia

pip install -e . --ignore-installed
pip install ftfy regex tqdm git+https://github.com/openai/CLIP.git
pip install git+https://github.com/huggingface/diffusers.git
pip install git+https://github.com/TimDettmers/bitsandbytes.git
# install ip-adapter
pip install diffusers==0.22.1
pip install git+https://github.com/tencent-ailab/IP-Adapter.git
cd IP-Adapter
git lfs install
git clone https://huggingface.co/h94/IP-Adapter
mv IP-Adapter/models models
mv IP-Adapter/sdxl_models sdxl_models
# install codeformer 
git clone https://github.com/sczhou/CodeFormer.git $ADB_PROJECT_ROOT/diffshortcut/defenses
# cd CodeFormer; pip install -e .
```

## Data and Checkpoint Dependencies
- put LIQE checkpoint `https://drive.google.com/file/d/1GoKwUKNR-rvX11QbKRN8MuBZw2hXKHGh/view` to `./LIQE/checkpoints/`
- dataset 
    - We use the open-source dataset, VGGFace2 and CelebA-HQ processed by AntiDreamBooth, which can be found at this [google drive](https://drive.google.com/drive/folders/1JX4IM6VMkkv4rER99atS4x4VGnoRNByV). Furthermore, for the WikiArt dataset, we use the open-source huggingface version [here](https://huggingface.co/datasets/huggan/wikiart) and filter those images from the same artists with the same style. After downloading, process the dataset with the same process in [MetaCloak](https://github.com/liuyixin-louis/MetaCloak). 
- model: download Stable Diffusion Models into `./SD/` folder, same for other variants
    - 2.1base https://huggingface.co/stabilityai/stable-diffusion-2-1-base
- weights
  - DPM for Purify: download to `/weights/256x256_diffusion_uncond.pt` from `https://github.com/openai/guided-diffusion`

## Simple Purification Code 
```shell
# activate your conda env
export input_dir="YOUR_INPUT_DIR_THAT_CONTAINS_IMAGES"
export output_dir_code="YOUR_OUTPUT_DIR_FOR_CODE"
export output_dir="YOUR_OUTPUT_DIR_FOR_PURIFIED_IMAGES"
export class_name='person'
bash scripts/sub/defense/code.sh $input_dir $output_dir_code
bash scripts/sub/defense/sr.sh $output_dir_code $output_dir 
# you will get the purified images in $output_dir
```

## Running the Experiments
```shell
# Table #1, main setting 
bash scripts/main/main-table/merge_run.sh 
# Adaptive Attack 
bash scripts/main/AA/merge_run.sh
# ablation study
bash scripts/main/ablation/merge_run.sh
# timing for each diffuison-based methods
bash scripts/main/time/test-time.sh
```

## Evaluation Code 
- Please see `diffshortcut/get_score_tempalte.py` for the evaluation code template. Change the `exp_name` and `dataset_name` to the corresponding experiment and dataset setting. 