#!/bin/bash

# Check if the correct number of arguments is provided
if [ "$#" -ne 1 ]; then
    echo "Usage: $0 <directory>"
    exit 1
fi

directory=$1

# Function to process each file
process_file() {
    local file=$1
    # Create a temporary file to store the output
    temp_file=$(mktemp)
    # Loop through each line of the file
    while IFS= read -r line; do
        # Use sed to remove lines that start with a comment
        echo "$line" | sed '/^\s*#/d' >> "$temp_file"
    done < "$file"
    # Move the temporary file to the original file
    mv "$temp_file" "$file"
    echo "Comments removed from $file"
}

# Export the function so it can be used by find
export -f process_file

# Find all files in the directory and process them
find "$directory" -type f -exec bash -c 'process_file "$0"' {} \;

echo "Comments removed from all files in $directory"
