dir_of_this_file="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
source $dir_of_this_file/generic.sh

pgd_alpha=$(echo "scale=3; $step_size/255" | bc)

###### the following are method-related variables ######
MODEL_CKPT_PATH=$ADB_PROJECT_ROOT/SD
sd15_path="$MODEL_CKPT_PATH/stable-diffusion-v1-5"
sd14_path="$MODEL_CKPT_PATH/stable-diffusion-v1-4"
sd21_path="$MODEL_CKPT_PATH/stable-diffusion-2-1-base"
ref_model_path="${sd14_path},${sd15_path},${sd21_path}"
# round="50"
eps=$(echo "scale=3; $r/255" | bc)
round=final
export INSTANCE_DIR_CHECK="$OUTPUT_DIR/noise-ckpt/${round}"

source activate $ADB_ENV_NAME
cd $ADB_PROJECT_ROOT/diffshortcut

if [ ! -d "$INSTANCE_DIR_CHECK" ]; then 
  {
      python3 attacks/algs/ensemble_aspl.py \
  --pretrained_model_name_or_path=${ref_model_path} \
  --enable_xformers_memory_efficient_attention \
  --instance_data_dir_for_train=$CLEAN_TRAIN_DIR \
  --instance_data_dir_for_adversarial=$CLEAN_ADV_DIR \
  --instance_prompt="a photo of $gen_prompt $class_name" \
  --class_data_dir=$CLASS_DIR \
  --num_class_images=200 \
  --class_prompt="a photo of $class_name" \
  --output_dir=$OUTPUT_DIR \
  --center_crop \
  --with_prior_preservation \
  --prior_loss_weight=1.0 \
  --resolution=512 \
  --train_text_encoder \
  --train_batch_size=1 \
  --max_train_steps=50 \
  --max_f_train_steps=3 \
  --max_adv_train_steps=6 \
  --checkpointing_iterations=10 \
  --learning_rate=5e-7 \
  --pgd_alpha=$pgd_alpha \
  --pgd_eps=$eps ;
  }
else
  echo "instance dir exists"
fi; 