from data_provider.data_factory import data_provider
from exp.exp_basic import Exp_Basic
from utils.tools import EarlyStopping, adjust_learning_rate, visual
from utils.metrics import metric
import torch
import torch.nn as nn
from torch import optim
import os
import time
import warnings
import numpy as np
from utils.dtw_metric import dtw,accelerated_dtw
from utils.augmentation import run_augmentation,run_augmentation_single
from models.utils import T2V
from models.visio import save
import random
from exp.ssim_torch import ssim
import math
warnings.filterwarnings('ignore')


class Exp_Long_Term_Forecast_new(Exp_Basic):
    def __init__(self, args):
        super(Exp_Long_Term_Forecast_new, self).__init__(args)
    

    def _build_model(self):
        model = self.model_dict[self.args.model].Model(self.args).float()

        if self.args.use_multi_gpu and self.args.use_gpu:
            model = nn.DataParallel(model, device_ids=self.args.device_ids)
        return model
    def _build_model2(self):
        model = self.model_dict[self.args.model2].Model(self.args).float()

        if self.args.use_multi_gpu and self.args.use_gpu:
            model = nn.DataParallel(model, device_ids=self.args.device_ids)
        return model

    def _get_data(self, flag):
        data_set, data_loader = data_provider(self.args, flag)
        return data_set, data_loader

    def _select_optimizer(self):
        model_optim = optim.Adam(self.model.parameters(), lr=self.args.learning_rate)
        return model_optim

    def _select_criterion(self):
        criterion = nn.MSELoss()
        return criterion
    def torch_ssim(self,img, ref,device):  
        return ssim(torch.unsqueeze(img, 0), torch.unsqueeze(ref, 0),device=device)

    def vali(self, vali_data, vali_loader, criterion):
        total_loss1 = []
        total_loss2 = []
        self.model.eval()
        self.model2.load_state_dict(torch.load('./checkpoints/long_term_forecast_ETTh1_96_720_DTFE_ETTh1_ftM_sl96_ll48_pl720_dm128_nh8_el1_dl1_df128_expand2_dc4_fc3_ebtimeF_dtTrue_Exp_0/checkpoint.pth'))
        with torch.no_grad():

            
            for i, (batch_x, batch_y, batch_x_mark, batch_y_mark) in enumerate(vali_loader):
                if i%10==0:
                    print(i)
                batch_x = batch_x.float().to(self.device)
                batch_y = batch_y.float()

                batch_x_mark = batch_x_mark.float().to(self.device)
                batch_y_mark = batch_y_mark.float().to(self.device)
                f_dim = -1 if self.args.features == 'MS' else 0
                batch_y = batch_y[:, -self.args.pred_len:, f_dim:].to(self.device)

                # decoder input
                dec_inp = torch.zeros_like(batch_y[:, -self.args.pred_len:, :]).float()
                dec_inp = torch.cat([batch_y[:, :self.args.label_len, :], dec_inp], dim=1).float().to(self.device)
                # encoder - decoder
                if self.args.use_amp:
                    with torch.cuda.amp.autocast():
                        if self.args.output_attention:
                            outputs = self.model(batch_x, batch_x_mark, dec_inp, batch_y_mark)[0]
                        else:
                            outputs = self.model(batch_x, batch_x_mark, dec_inp, batch_y_mark)
                else:
                    if self.args.output_attention:
                        outputs = self.model(batch_x, batch_x_mark, dec_inp, batch_y_mark)[0]
                    else:
                        outputs1,outputs2,px = self.model2(batch_x, batch_x_mark, dec_inp, batch_y_mark)
                        realoutputs = outputs1.clone()
                        predn = self.args.pred_len // 96
                        for i in range(self.args.c_out):
                            if self.args.pred_len == 336 or self.args.pred_len == 720:
                                for j in range(predn):
                                    _,outputs,_,_,_,_ = self.model(batch_x, batch_x_mark, dec_inp, batch_y_mark,outputs1[:,j*96:(j+1)*96,:],outputs2[:,j*96:(j+1)*96,:],i)
                                    realoutputs[:,j*96:(j+1)*96,i]=outputs[:,:,i]
                                _,outputs,_,_,_,_ = self.model(batch_x, batch_x_mark, dec_inp, batch_y_mark,outputs1[:,-96:,:],outputs2[:,j*96:(j+1)*96,:],i)
                                realoutputs[:,-48:,i]=outputs[:,-48:,i]
                            else:
                                for j in range(predn):
                                    x,outputs,_,_,z,y = self.model(batch_x, batch_x_mark, dec_inp, batch_y_mark,outputs1[:,j*96:(j+1)*96,:],outputs2[:,j*96:(j+1)*96,:],i)
                                    realoutputs[:,j*96:(j+1)*96,i]=outputs[:,:,i]

                #x,outputs,means,stdev,z,y = self.model(batch_x, batch_x_mark, dec_inp, batch_y_mark,outputs1,5)

                f_dim = -1 if self.args.features == 'MS' else 0
                realoutputs = realoutputs[:, -self.args.pred_len:, f_dim:]
                #outputs = outputs[:, -self.args.pred_len:, f_dim:]
                pred = realoutputs.detach().cpu()
                pred1 = px.detach().cpu()
                true = batch_y.detach().cpu()

                loss1 = criterion(pred, true)
                loss2 = criterion(pred1, true)
                
                total_loss1.append(loss1)
                total_loss2.append(loss2)
                pred1 = outputs1.detach().cpu()

                    
        total_loss1 = np.average(total_loss1)
        total_loss2 = np.average(total_loss2)
        print(total_loss1)
        print(total_loss2)
        self.model.train()


        return total_loss1

    def train(self, setting):
        train_data, train_loader = self._get_data(flag='train')
        vali_data, vali_loader = self._get_data(flag='val')
        test_data, test_loader = self._get_data(flag='test')
        self.model2.load_state_dict(torch.load('./checkpoints/long_term_forecast_ETTh1_96_720_DTFE_ETTh1_ftM_sl96_ll48_pl720_dm128_nh8_el1_dl1_df128_expand2_dc4_fc3_ebtimeF_dtTrue_Exp_0/checkpoint.pth'))
        self.model2.eval()
        path = os.path.join(self.args.checkpoints, setting)
        if not os.path.exists(path):
            os.makedirs(path)

        time_now = time.time()

        train_steps = len(train_loader)
        early_stopping = EarlyStopping(patience=self.args.patience, verbose=True)

        model_optim = self._select_optimizer()
        criterion = self._select_criterion()

        if self.args.use_amp:
            scaler = torch.cuda.amp.GradScaler()
            
            

        for epoch in range(self.args.train_epochs):
            iter_count = 0
            train_loss = []

            self.model.train()
            epoch_time = time.time()
            
            for i, (batch_x, batch_y, batch_x_mark, batch_y_mark) in enumerate(train_loader):
                n = random.randint(0, self.args.c_out-1)
                iter_count += 1
                model_optim.zero_grad()
                batch_x = batch_x.float().to(self.device)
                batch_y = batch_y.float().to(self.device)
                batch_x_mark = batch_x_mark.float().to(self.device)
                batch_y_mark = batch_y_mark.float().to(self.device)

                # decoder input
                dec_inp = torch.zeros_like(batch_y[:, -self.args.pred_len:, :]).float()
                dec_inp = torch.cat([batch_y[:, :self.args.label_len, :], dec_inp], dim=1).float().to(self.device)

                # encoder - decoder
               
                if self.args.use_amp:
                    with torch.cuda.amp.autocast():
                        if self.args.output_attention:
                            outputs = self.model(batch_x, batch_x_mark, dec_inp, batch_y_mark)[0]
                        else:
                            outputs = self.model(batch_x, batch_x_mark, dec_inp, batch_y_mark)

                        f_dim = -1 if self.args.features == 'MS' else 0
                        outputs = outputs[:, -self.args.pred_len:, f_dim:]
                        batch_y = batch_y[:, -self.args.pred_len:, f_dim:].to(self.device)
                        loss = criterion(outputs, batch_y)
                        train_loss.append(loss.item())
                else:
                    if self.args.output_attention:
                        outputs = self.model(batch_x, batch_x_mark, dec_inp, batch_y_mark)[0]
                    else:
                        with torch.no_grad():
                            outputs1,outputs2,p = self.model2(batch_x, batch_x_mark, dec_inp, batch_y_mark)
                        k = random.randint(0, self.args.pred_len-96)
                        x,outputs,means,stdev,z,y = self.model(batch_x, batch_x_mark, dec_inp, batch_y_mark,outputs1[:,k:k+96,:],outputs2[:,k:k+96,:],n)

                    f_dim = -1 if self.args.features == 'MS' else 0
                    outputs = outputs[:, -self.args.pred_len:, f_dim:]
                    batch_y = batch_y[:, -self.args.pred_len:, f_dim:].to(self.device)
                    
                    batch_y -= means
                    batch_y /= stdev
                    batch_y = batch_y[:, k:k+96,:]
                    loss = criterion(x[:,n], T2V(batch_y,y)[0][:,n])

                    
                    #loss = criterion(outputs, batch_y)
                    train_loss.append(loss.item())
                

                if (i + 1) % 100 == 0:
                    print("\titers: {0}, epoch: {1} | loss: {2:.7f}".format(i + 1, epoch + 1, loss.item()))
                    speed = (time.time() - time_now) / iter_count
                    left_time = speed * ((self.args.train_epochs - epoch) * train_steps - i)
                    print('\tspeed: {:.4f}s/iter; left time: {:.4f}s'.format(speed, left_time))
                    iter_count = 0
                    time_now = time.time()

                if self.args.use_amp:
                    scaler.scale(loss).backward()
                    scaler.step(model_optim)
                    scaler.update()
                else:
                    loss.backward()
                    model_optim.step()
                    

            print("Epoch: {} cost time: {}".format(epoch + 1, time.time() - epoch_time))
            train_loss = np.average(train_loss)
            #vali_loss = self.vali(vali_data, vali_loader, criterion)
            test_loss = self.vali(test_data, test_loader, criterion)
            train_loss = test_loss
            vali_loss = test_loss
            print("Epoch: {0}, Steps: {1} | Train Loss: {2:.7f} Vali Loss: {3:.7f} Test Loss: {4:.7f}".format(
                epoch + 1, train_steps, train_loss, vali_loss, test_loss))
            f = open("exp.txt", 'a')
            f.write("  \n")
            f.write('epoch:{},train:{}, vali:{}, test:{}'.format(epoch + 1, train_loss, vali_loss,test_loss))
            f.write('\n')
            f.close()
            early_stopping(vali_loss, self.model, path)
            if early_stopping.early_stop:
                print("Early stopping")
                break
            adjust_learning_rate(model_optim, epoch + 1, self.args)

        best_model_path = path + '/' + 'checkpoint.pth'
        self.model.load_state_dict(torch.load(best_model_path))







        

        return self.model
    

    def test(self, setting, test=0):
        test_data, test_loader = self._get_data(flag='test')
        if test:
            print('loading model')
            self.model.load_state_dict(torch.load(os.path.join('./checkpoints/' + setting, 'checkpoint.pth')))

        preds = []
        trues = []
        original_string = './checkpoints/' + setting+ '/checkpoint.pth'
        new_string = original_string.replace("newTransformer", "deTransformer")
        self.model2.load_state_dict(torch.load(new_string))
        self.model.load_state_dict(torch.load('./checkpoints/long_term_forecast_Exchange_96_96_newTransformer_custom_ftM_sl96_ll48_pl96_dm512_nh8_el2_dl1_df512_expand2_dc4_fc3_ebtimeF_dtTrue_Exp_0/checkpoint.pth'))
        self.model2.eval()
        folder_path = './test_results/' + setting + '/'
        if not os.path.exists(folder_path):
            os.makedirs(folder_path)

        self.model.eval()
        n = self.args.c_out 
        ssim = []
        with torch.no_grad():
            for i, (batch_x, batch_y, batch_x_mark, batch_y_mark) in enumerate(test_loader):
                if i % 10 == 0:
                    print(i)
                batch_x = batch_x.float().to(self.device)
                batch_y = batch_y.float().to(self.device)

                batch_x_mark = batch_x_mark.float().to(self.device)
                batch_y_mark = batch_y_mark.float().to(self.device)

                # decoder input
                dec_inp = torch.zeros_like(batch_y[:, -self.args.pred_len:, :]).float()
                dec_inp = torch.cat([batch_y[:, :self.args.label_len, :], dec_inp], dim=1).float().to(self.device)

                outputs1,outputs2,p = self.model2(batch_x, batch_x_mark, dec_inp, batch_y_mark)
                realoutputs = outputs1.clone()
                #realoutputs = torch.zeros(outputs1.shape).to(outputs1.device).to(torch.float32)
                predn = self.args.pred_len // 96
                for i in range(n):
                    if self.args.pred_len == 336 or self.args.pred_len == 720:
                        for j in range(predn):
                            _,outputs,_,_,_,_ = self.model(batch_x, batch_x_mark, dec_inp, batch_y_mark,outputs1[:,j*96:(j+1)*96,:],outputs2[:,j*96:(j+1)*96,:],i)
                            realoutputs[:,j*96:(j+1)*96,i]=outputs[:,:,i]
                        _,outputs,_,_,_,_ = self.model(batch_x, batch_x_mark, dec_inp, batch_y_mark,outputs1[:,-96:,:],outputs2[:,j*96:(j+1)*96,:],i)
                        realoutputs[:,-48:,i]=outputs[:,-48:,i]
                    else:
                        for j in range(predn):
                            _,outputs,_,_,_,_ = self.model(batch_x, batch_x_mark, dec_inp, batch_y_mark,outputs1[:,j*96:(j+1)*96,:],outputs2[:,j*96:(j+1)*96,:],i)
                            realoutputs[:,j*96:(j+1)*96,i]=outputs[:,:,i]

                f_dim = -1 if self.args.features == 'MS' else 0
                realoutputs = realoutputs[:, -self.args.pred_len:, :]
                batch_y = batch_y[:, -self.args.pred_len:, :].to(self.device)
                sum = 0
                B,_,_ = batch_x.shape
                for b in range(B):
                    x1,y = T2V(batch_y)
                    sum = sum + self.torch_ssim(x1[b,:,:,:],T2V(realoutputs,y)[0][b,:,:,:],realoutputs.device)
                sum = sum / B
                ssim.append(sum.item()) 
                realoutputs = realoutputs.detach().cpu().numpy()
                batch_y = batch_y.detach().cpu().numpy()
                if test_data.scale and self.args.inverse:
                    shape = realoutputs.shape
                    realoutputs = test_data.inverse_transform(realoutputs.squeeze(0)).reshape(shape)
                    batch_y = test_data.inverse_transform(batch_y.squeeze(0)).reshape(shape)
        
                realoutputs = realoutputs[:, :, f_dim:]
                batch_y = batch_y[:, :, f_dim:]

                pred = realoutputs
                true = batch_y

                preds.append(pred)
                trues.append(true)
                
                if i % 20 == 0:
                    input = batch_x.detach().cpu().numpy()
                    if test_data.scale and self.args.inverse:
                        shape = input.shape
                        input = test_data.inverse_transform(input.squeeze(0)).reshape(shape)
                    gt = np.concatenate((input[0, :, -1], true[0, :, -1]), axis=0)
                    pd = np.concatenate((input[0, :, -1], pred[0, :, -1]), axis=0)
                    visual(gt, pd, os.path.join(folder_path, str(i) + '.pdf'))

        preds = np.array(preds)
        trues = np.array(trues)
        print('test shape:', preds.shape, trues.shape)
        preds = preds.reshape(-1, preds.shape[-2], preds.shape[-1])
        trues = trues.reshape(-1, trues.shape[-2], trues.shape[-1])
        print('test shape:', preds.shape, trues.shape)

        # result save
        folder_path = './results/' + setting + '/'
        if not os.path.exists(folder_path):
            os.makedirs(folder_path)
        ssim = np.average(ssim)
        # dtw calculation
        if self.args.use_dtw:
            dtw_list = []
            manhattan_distance = lambda x, y: np.abs(x - y)
            for i in range(preds.shape[0]):
                x = preds[i].reshape(-1,1)
                y = trues[i].reshape(-1,1)
                if i % 100 == 0:
                    print("calculating dtw iter:", i)
                d, _, _, _ = accelerated_dtw(x, y, dist=manhattan_distance)
                dtw_list.append(d)
            dtw = np.array(dtw_list).mean()
        else:
            dtw = -999
            

        mae, mse, rmse, mape, mspe = metric(preds, trues)
        print('mse:{}, mae:{}, dtw:{}'.format(mse, mae, dtw))
        f = open("result_long_term_forecast.txt", 'a')
        f.write(setting + "  \n")
        f.write('mse:{}, mae:{}, dtw:{}'.format(mse, mae, dtw))
        f.write('\n')
        f.write('SSIM:{}'.format(ssim))
        f.write('\n')
        f.write('\n')
        f.close()

        np.save(folder_path + 'metrics.npy', np.array([mae, mse, rmse, mape, mspe]))
        np.save(folder_path + 'pred.npy', preds)
        np.save(folder_path + 'true.npy', trues)

        return
