import torch
import torch.nn as nn
import torch.nn.functional as F
def T2V(x,xlens=None):
    B, T, N = x.shape
    if xlens == None:
        xlenlen = torch.max(torch.abs(x), dim=0)[0]

        xlen = torch.max(xlenlen,dim = 0)[0]
        xlens = xlen.tolist()
    else:
        xlen =torch.tensor(xlens).to(x.device)
    mean = x / xlen.unsqueeze(0).unsqueeze(1)  
    mean = mean.clamp(max=1)
    mean = mean.clamp(min=-1)
    mean = mean * 100  
    res = torch.zeros(B, N, 200, T, device=x.device, dtype=torch.float32)
    index = mean.to(torch.long)+ 100
    index = torch.clamp(index, 0, 199).to(torch.long)
    index = index.permute(0, 2, 1).unsqueeze(2)  
    res.scatter_(2, index, 1.0) 
    for j in range(1, 100):
        new_tensor1 = torch.where(index+j > 199, 199, index+j)
        res.scatter_(2, new_tensor1, 1.0-0.01*j) 
        new_tensor2 = torch.where(index-j <1, 0, index-j)
        res.scatter_(2, new_tensor2, 1.0-0.01*j) 
    return res, xlens
def V2T(x, y):
    B, C, H, W = x.shape
    mx, max_indices = torch.max(x, dim=2)
    max_indices = (max_indices - 100) / 100
    tensory = torch.tensor(y).to(x.device)
    max_indices = max_indices * tensory.unsqueeze(1)
    return max_indices.permute(0, 2, 1)

