function demo_fda_10
clc;clear all;close all;
% This program solves the following optimization problem:
%
%         tr(X'CX) + rho (||X||_1 - ||X||_[k])
% min_X ----------------------------------------,   s.t.   X'X=I
%         tr(X'DX)
%

clc;clear all;close all;
addpath('util','solver','data');
randn('seed',0); rand('seed',0);

rho = 100;

data_ids    = [1  2  3  4  5  6  7  8];
time_limits = [20 20 20 20 20 20 20 20];

for id = 1:length(data_ids)
    randn('seed',1); rand('seed',1);
    fprintf('data: %d\n',id);
    data_id = data_ids(id);
    timeLimit = time_limits(id);
    
    
    [dat_x,dat_y] = SelectData1(data_id);
    [dat_C,dat_D] = getFisher_CD(dat_x,dat_y);



    n = size(dat_C,1);
    r = 20;
    k = round(0.1*n*r);
    X = OrthProj(randn(n,r));
    timeIntervel = 1;% Record the objective value in every timeIntervel second

    max_iter = 5000000;
    beta0 = rho*100;

    
    alg_xi = 0.5;
    IsMultiplier = 0;

    [X1,fobjs1,ts1] = SubGrad(X,dat_C,dat_D,rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit);
    [X2,fobjs2,ts2] = FADMM_D(X,dat_C,dat_D,rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit,IsMultiplier);
    [X3,fobjs3,ts3] = FADMM_Q(X,dat_C,dat_D,rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit,IsMultiplier);
    [X4,fobjs4,ts4] = FSA(X,dat_C,dat_D,rho,k,max_iter,timeIntervel,timeLimit);
    [X5,fobjs5,ts5] = FSA2(X,dat_C,dat_D,rho,k,max_iter,timeIntervel,timeLimit);
    IsMultiplier = 1;
    [X6,fobjs6,ts6] = FADMM_D(X,dat_C,dat_D,rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit,IsMultiplier);
    [X7,fobjs7,ts7] = FADMM_Q(X,dat_C,dat_D,rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit,IsMultiplier);

    tt0 = 1;
    fobjs1 = fobjs1(tt0:end); fobjs2 = fobjs2(tt0:end); fobjs3 = fobjs3(tt0:end); fobjs4 = fobjs4(tt0:end); fobjs5 = fobjs5(tt0:end);  fobjs6 = fobjs6(tt0:end); fobjs7 = fobjs7(tt0:end);
    ts1 = ts1(tt0:end); ts2 = ts2(tt0:end); ts3 = ts3(tt0:end); ts4 = ts4(tt0:end); ts5 = ts5(tt0:end); ts5 = ts5(tt0:end); ts6 = ts6(tt0:end); ts7 = ts7(tt0:end);
    
    figure('color','w');
    myplot = @semilogy;
    pcolor = loadcolor; % yellow
    myplot(ts1,fobjs1,'--kv','LineWidth',3,'MarkerSize',3,'color', pcolor.purple); hold on;
    myplot(ts2,fobjs2,'-.mo','LineWidth',3,'MarkerSize',3,'color',  pcolor.blue); hold on;
    myplot(ts3,fobjs3,'--kv','LineWidth',3,'MarkerSize',3,'color', pcolor.pink); hold on;
    myplot(ts4,fobjs4,'--x','LineWidth',3,'MarkerSize',3,'color', pcolor.orange); hold on;
    myplot(ts5,fobjs5,'-.d','LineWidth',3,'MarkerSize',3,'color', pcolor.crimson); hold on;
    myplot(ts6,fobjs6,'-.b^','LineWidth',3,'MarkerSize',3,'color', pcolor.green); hold on;
    myplot(ts7,fobjs7,'--s','LineWidth',3,'MarkerSize',3,'color', pcolor.red); hold on;

%     grid on;
    hleg=legend('SPM','SPGM-D','SPGM-Q','FSA-I','FSA-II','FADMM-D','FADMM-Q');
    set(hleg,'FontSize',12,'FontWeight','normal');
    set(hleg,'Fontname','times new Roman');
%     set(hleg,'Location','EastOutside');
%    set(hleg,'Location','SouthEast');
    set(hleg,'Location','Best');
    set(gca,'Fontsize', 12);
    set(hleg, 'Color', 'none');% set(hleg, 'Box', 'off'); 
    xlabel('Time (seconds)','FontSize',12)
    ylabel('Objective','FontSize',12,'interpreter','latex')
    all_fobj = [fobjs1;fobjs2;fobjs3;fobjs4;fobjs5;fobjs6;fobjs7];
    
    axis([0,timeLimit*1.01,min(all_fobj),max(all_fobj)]);
    
    set(gcf,'paperpositionmode','auto')
    print(sprintf('%s_%d.eps',mfilename,id),'-depsc2','-loose');
    print(sprintf('%s_%d.png',mfilename,id),'-dpng');
%     print(sprintf('%s_%d.pdf',mfilename,id),'-dpdf', '-r0');
    close all;
    
    fprintf('\n');
end


function [X,fobjs,ts] = FADMM_Q(X,dat_C,dat_D,rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit,IsMultiplier)
%         tr(X'CX) + rho (||X||_1 - ||X||_[k])
% min_X ----------------------------------------,   s.t.   X'X=I
%         tr(X'DX)

xi = alg_xi;
theta = 1.01;
tau = 0.5;
% beta0 = 100;
p = 1/3;
sigma = 1.2;
alpha = (theta-1)/ ((theta+1)*(1+tau+tau*xi))+eps;
alpha = 0;
sigma=1;

chi = 2*sigma*sqrt(1/sigma + xi/(sigma^2))   /   (2-sigma);
X_old = X;

Lf = norm(dat_C)^2;

Y = 1*X.*randn(size(X));


if(IsMultiplier==1)
    Z = 1*X.*randn(size(X));
    fprintf('FADMM_Q: \n');
else
    Z = 0.00*X.*randn(size(X));
    fprintf('SPGM_Q: \n');
end

fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(X)ComputeTrueObj(X,dat_C,dat_D,rho,k);
% fobjs = [fobjs;HandleObj(X)]; ts = [ts;etime(clock,initt)];


for iter = 0:max_iter
    beta = beta0*(1+xi*iter^p);
    ellbeta = Lf+beta;
    mu = chi/beta;
    Xc = X + alpha*(X-X_old);
    [tk_fobj,tk_subgrad] = topksum(X,k);
    if(IsMultiplier==1)
        Ut = mdot(X,dat_C*X) - rho*tk_fobj + rho*L1_norm_mu(Y,mu) + mdot(X-Y,Z) + 0.5*beta*norm(X-Y,'fro')^2;
    else
        Ut = mdot(X,dat_C*X) - rho*tk_fobj + rho*norm(Y(:),1) + mdot(X-Y,Z) + 0.5*beta*norm(X-Y,'fro')^2;
    end
    
    dx = mdot(X,dat_D*X);
    lambda = sqrt(dx)/Ut;
    grad1 = 2*dat_C*Xc + Z + beta*(Xc-Y)  - rho*tk_subgrad - (2/lambda)*0.5*dx^(-0.5)*2*dat_D*X;
    X1 = Xc - grad1 / (theta*ellbeta);
    X1 = OrthProj(X1);
    d = @(X)mdot(X,dat_D*X);
    if(d(X)>d(X1)*tau)
        grad2 = 2*dat_C*X  + Z  + beta*(X-Y)  - rho*tk_subgrad - (2/lambda)*0.5*dx^(-0.5)*2*dat_D*X;
        X2 = X - grad2 / (theta*ellbeta);
        X = OrthProj(X2);
    else
        X = X1;
    end
    
    
    B = X+Z/beta;
    % min_Y  rho [||Y||_1]_{\mu} + 0.5 beta_bar ||Y - B||_F^2
    if(IsMultiplier==1)
        Y = smooth_prox_l1(B,mu,beta/rho);
        diff = X-Y;
        Z = Z + sigma*beta*diff;
    else
        Y = prox_l1(B,rho/beta);
        diff = X-Y;
        Z = Z*0;;
    end
    %     true_fobj = ComputeTrueObj(X,dat_C,dat_D,rho,k);
    %     fprintf('iter:%d, fobj:%f, dist:%f\n',iter,true_fobj,norm(X-Y,'fro'));
    %     his(iter+1) = true_fobj;
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(X);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,true_fobj,norm(diff,'fro'),beta);
    end
    
    
end



function [X,fobjs,ts] = FADMM_D(X,dat_C,dat_D,rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit,IsMultiplier)
%         tr(X'CX) + rho (||X||_1 - ||X||_[k])
% min_X ----------------------------------------,   s.t.   X'X=I
%         tr(X'DX)
xi = alg_xi;
theta = 1.01;
tau = 0.5;
% beta0 = 100;
p = 1/3;
sigma = 1.2;
alpha = (theta-1)/ ((theta+1)*(1+tau+tau*xi))+eps;
alpha = 0;
sigma=1;

chi = 2*sigma*sqrt(1/sigma + xi/(sigma^2))   /   (2-sigma);
X_old = X;

Lf = norm(dat_C)*2;
Y = X.*randn(size(X));
if(IsMultiplier==1)
    Z = X.*randn(size(X));
    fprintf('FADMM_D: \n');
else
    Z = 0.00*X.*randn(size(X));
    fprintf('SPGM_D: \n');
end

fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(X)ComputeTrueObj(X,dat_C,dat_D,rho,k);
% fobjs = [fobjs;HandleObj(X)]; ts = [ts;etime(clock,initt)];


for iter = 0:max_iter
    beta = beta0*(1+xi*iter^p);
    ellbeta = Lf+beta;
    mu = chi/beta;
    Xc = X + alpha*(X-X_old);
    [tk_fobj,tk_subgrad] = topksum(X,k);
    if(IsMultiplier==1)
        Ut = mdot(X,dat_C*X) - rho*tk_fobj + rho*L1_norm_mu(Y(:),mu) + mdot(X-Y,Z) + 0.5*beta*norm(X-Y,'fro')^2;
    else
        Ut = mdot(X,dat_C*X) - rho*tk_fobj + rho*norm(Y(:),1) + mdot(X-Y,Z) + 0.5*beta*norm(X-Y,'fro')^2;
    end
    
    lambda = Ut / mdot(X,dat_D*X);
    grad1 = 2*dat_C*Xc + Z + beta*(Xc-Y) - rho*tk_subgrad - lambda*2*dat_D*X;
    X1 = Xc - grad1 / (theta*ellbeta);
    X1 = OrthProj(X1);
    d = @(X)mdot(X,dat_D*X);
    if(d(X)>d(X1)*tau)
        grad2 = 2*dat_C*X  + Z  + beta*(X-Y) - rho*tk_subgrad - lambda*2*dat_D*X;
        X2 = X - grad2 / (theta*ellbeta);
        X = OrthProj(X2);
    else
        X = X1;
    end
    
    
    B = X+Z/beta;
    % min_Y  rho [||Y||_1]_{\mu} + 0.5 beta_bar ||Y - B||_F^2
    
    if(IsMultiplier==1)
        Y = smooth_prox_l1(B,mu,beta/rho);
        diff = X-Y;
        Z = Z + sigma*beta*diff;
    else
        Y = prox_l1(B,rho/beta);
        diff = X-Y;
        Z = Z*0;
    end
    %     true_fobj = ComputeTrueObj(X,dat_C,dat_D,rho,k);
    %     fprintf('iter:%d, fobj:%f, dist:%f\n',iter,true_fobj,norm(X-Y,'fro'));
    %     his(iter+1) = true_fobj;
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(X);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,true_fobj,norm(diff,'fro'),beta);
    end
    
    
    
end


function [X,fobjs,ts] = SPGM(X,dat_C,dat_D,rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit)
%         tr(X'CX) + rho (||X||_1 - ||X||_[k])
% min_X ----------------------------------------,   s.t.   X'X=I
%         tr(X'DX)
xi = alg_xi;
theta = 1.01;
tau = 0.5;
% beta0 = 100;
p = 1/3;
sigma = 1.2;
alpha = (theta-1)/ ((theta+1)*(1+tau+tau*xi))+eps;
alpha = 0;
sigma=1;

chi = 2*sigma*sqrt(1/sigma + xi/(sigma^2))   /   (2-sigma);
X_old = X;

Lf = norm(dat_C)*2;
Y = 0.01*X.*randn(size(X));
Z = 0.00*X.*randn(size(X));

fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(X)ComputeTrueObj(X,dat_C,dat_D,rho,k);
% fobjs = [fobjs;HandleObj(X)]; ts = [ts;etime(clock,initt)];
fprintf('SPGM: \n');

for iter = 0:max_iter
    beta = beta0*(1+xi*iter^p);
    ellbeta = Lf+beta;
    mu = chi/beta;
    Xc = X + alpha*(X-X_old);
    [tk_fobj,tk_subgrad] = topksum(X,k);
    Ut = mdot(X,dat_C*X) - rho*tk_fobj + rho*norm(Y(:),1) + mdot(X-Y,Z) + 0.5*beta*norm(X-Y,'fro')^2;
    %     ut = mdot(X,dat_C*X) - rho*tk_fobj + rho*L1_norm_mu(Y(:),mu) + mdot(X-Y,Z) + 0.5*beta*norm(X-Y,'fro')^2;
    
    lambda = Ut / mdot(X,dat_D*X);
    grad1 = 2*dat_C*Xc + Z + beta*(Xc-Y) - rho*tk_subgrad - lambda*2*dat_D*X;
    X1 = Xc - grad1 / (theta*ellbeta);
    X1 = OrthProj(X1);
    d = @(X)mdot(X,dat_D*X);
    if(d(X)>d(X1)*tau)
        grad2 = 2*dat_C*X  + Z  + beta*(X-Y) - rho*tk_subgrad - lambda*2*dat_D*X;
        X2 = X - grad2 / (theta*ellbeta);
        X = OrthProj(X2);
    else
        X = X1;
    end
    
    
    B = X+Z/beta;
    % min_Y  rho [||Y||_1]_{\mu} + 0.5 beta_bar ||Y - B||_F^2
    %     Y = smooth_prox_l1(B,mu,beta/rho);
    Y = prox_l1(B,1/(beta/rho));
    diff = X-Y;
    %     Z = Z + sigma*beta*diff;
    %     true_fobj = ComputeTrueObj(X,dat_C,dat_D,rho,k);
    %     fprintf('iter:%d, fobj:%f, dist:%f\n',iter,true_fobj,norm(X-Y,'fro'));
    %     his(iter+1) = true_fobj;
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(X);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,true_fobj,norm(diff,'fro'),beta);
    end
    
    
    
end

function [X,fobjs,ts] = SPGMddd(X,dat_C,dat_D,rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit)
%         tr(X'CX) + rho (||X||_1 - ||X||_[k])
% min_X ----------------------------------------,   s.t.   X'X=I
%         tr(X'DX)
xi = alg_xi;
theta = 1.01;
tau = 0.5;
% beta0 = 100;
p = 1/3;
sigma = 1.2;
alpha = (theta-1)/ ((theta+1)*(1+tau+tau*xi))+eps;
alpha = 0;
sigma=1;
chi = 2*sigma*sqrt(1/sigma + xi/(sigma^2))   /   (2-sigma);
X_old = X;

Lf = norm(dat_C)^2;
Y = 0.01*X.*randn(size(X));
Z = 0*X.*randn(size(X));

fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(X)ComputeTrueObj(X,dat_C,dat_D,rho,k);
% fobjs = [fobjs;HandleObj(X)]; ts = [ts;etime(clock,initt)];
fprintf('SPGM: \n');

% F0 = HandleObj(X);

for iter = 0:max_iter
    beta = beta0*(1+xi*iter^p);
    ellbeta = Lf+beta;
    mu = chi/beta;
    Xc = X + alpha*(X-X_old);
    [tk_fobj,tk_subgrad] = topksum(X,k);
    ut = mdot(X,dat_C*X) - rho*tk_fobj + rho*norm(Y(:),1) + mdot(X-Y,Z) + 0.5*beta*norm(X-Y,'fro')^2;
    
    lambda = ut / mdot(X,dat_D*X);
    grad1 = 2*dat_C*Xc + Z + beta*(Xc-Y)  - rho*tk_subgrad - lambda*2*dat_D*X;
    X1 = Xc - grad1 / (theta*ellbeta);
    X1 = OrthProj(X1);
    d = @(X)mdot(X,dat_D*X);
    if(d(X)>d(X1)*tau)
        grad2 = 2*dat_C*X  + Z  + beta*(X-Y)  - rho*tk_subgrad - lambda*2*dat_D*X;
        X2 = X - grad2 / (theta*ellbeta);
        X = OrthProj(X2);
    else
        X = X1;
    end
    
    
    B = X+Z/beta;
    % min_Y  rho [||Y||_1]_{\mu} + 0.5 beta_bar ||Y - B||_F^2
    Y = smooth_prox_l1(B,mu,beta/rho);
    
    diff = X-Y;
    %     Z = Z + sigma*beta*diff;
    %     true_fobj = ComputeTrueObj(X,dat_C,dat_D,rho,k);
    %     fprintf('iter:%d, fobj:%f, dist:%f\n',iter,true_fobj,norm(X-Y,'fro'));
    %     his(iter+1) = true_fobj;
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = min(mean(fobjs),HandleObj(X));
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,true_fobj,norm(diff,'fro'),beta);
    end
    
    
    
end

function r = mean(x)
if(isempty(x))
    r = 1e100;
else
    r = sum(x)/length(x);
end


function [X,fobjs,ts] = SubGrad(X,dat_C,dat_D,rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit)
%         tr(X'CX) + rho (||X||_1 - ||X||_[k])
% min_X ----------------------------------------,   s.t.   X'X=I
%         tr(X'DX)
xi = alg_xi;
% beta0 = 1;
p = 1/3;

fprintf('SubGrad: \n');

fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(X)ComputeTrueObj(X,dat_C,dat_D,rho,k);
% fobjs = [fobjs;HandleObj(X)]; ts = [ts;etime(clock,initt)];

for iter = 0:max_iter
    beta = beta0*(1+xi*iter^p);
    [tk_fobj,tk_subgrad] = topksum(X,k);
    up = mdot(X,dat_C*X) + rho * (norm(X(:),1)-tk_fobj);
    down = mdot(X,dat_D*X);
    %     fobj = up / down;
    grad_up = 2*dat_C*X + rho*(sign(X) - tk_subgrad);
    grad_down = 2*dat_D*X;
    subgrad = (grad_up*down - up*grad_down) / (down^2);
    
    X = X - subgrad / beta;
    X = OrthProj(X);
    %     true_fobj = ComputeTrueObj(X,dat_C,dat_D,rho,k);
    %     fprintf('iter:%d, fobj:%f\n',iter,true_fobj);
    %     his(iter+1) = true_fobj;
    
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = min(mean(fobjs),HandleObj(X));
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f, beta:%f\n',iter,true_fobj,beta);
    end
    
end


function fobj = ComputeTrueObj(X,dat_C,dat_D,rho,k)
%         tr(X'CX) + rho (||X||_1 - ||X||_[k])
% min_X ----------------------------------------,   s.t.   X'X=I
%         tr(X'DX)

X = OrthProj(X);
up = mdot(X,dat_C*X) + rho * (norm(X(:),1)-topksum(X,k));
down = mdot(X,dat_D*X);
fobj = up / down;

function Y = smooth_prox_l1(B,mu,beta)
% min_Y  [||Y||_1]_{\mu} + 0.5 beta ||Y - B||_F^2
y_bar = prox_l1(B,mu+1/beta);
Y =  B/ ( 1/(beta*mu) + 1 )   +   y_bar / (1 + beta*mu)    ;


 

function [X,fobjs,ts] = FSA(X,dat_C,dat_D,rho,k,max_iter,timeIntervel,timeLimit)
%         tr(X'CX) + rho (||X||_1 - ||X||_[k])
% min_X ----------------------------------------,   s.t.   X'X=I
%         tr(X'DX)


fprintf('FSA \n');
fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(X)ComputeTrueObj(X,dat_C,dat_D,rho,k);
% fobjs = [fobjs;HandleObj(X)]; ts = [ts;etime(clock,initt)];

% h(X) = rho ||X||_1
% h*(Z)=  delta_{||Z||_{\inf}<=rho} (Z)

alpha = 1000;
gamma = 1/alpha;

Z = randn(size(X))*0.01;
U = randn(size(X))*0.01;
d = @(X) mdot(X,dat_D*X);
L = @(X,Z,U,alpha,gamma)( mdot(Z,X) + mdot(X,dat_C*X) + 0.5 * alpha* norm(X-U,'fro')^2 - 0.5*gamma*norm(Z,'fro')^2 ) ;
theta = L(X,Z,U,alpha,gamma) / d(X);
beta = 1;

for iter = 0:max_iter
    

    [tk_fobj,tk_subgrad] = topksum(X,k);
    grad = 2*dat_C*X + Z - theta*2*dat_D*X - rho*tk_subgrad;
    X = U - grad/alpha;
    X = OrthProj(X);
    U = (1-beta)*U + beta*X;
    Z1 = X/gamma;
    % Z = Prox(h*,1/gamma,Z1)
    % min_Z 0.5/mu ||Z-Z1||_F^2 + h*(Z)
    % min_Z 0.5/mu ||Z-Z1||_F^2, s.t. ||Z||_{\inf}<=rho
    Z = ProjBox(Z1,rho);
    theta = L(X,Z,U,alpha,gamma) / d(X);
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(X);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f \n',iter,true_fobj);
    end

    
end


function [X,fobjs,ts] = FSA2(X,dat_C,dat_D,rho,k,max_iter,timeIntervel,timeLimit)
%         tr(X'CX) + rho (||X||_1 - ||X||_[k])
% min_X ----------------------------------------,   s.t.   X'X=I
%         tr(X'DX)


fprintf('FSA2 \n');
fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(X)ComputeTrueObj(X,dat_C,dat_D,rho,k);
% fobjs = [fobjs;HandleObj(X)]; ts = [ts;etime(clock,initt)];

% h(X) = rho ||X||_1
% h*(Z)=  delta_{||Z||_{\inf}<=rho} (Z)

alpha = 100000;
gamma = 1/alpha;
Z = randn(size(X))*0.01;
U = randn(size(X))*0.01;
d = @(X) mdot(X,dat_D*X);
L = @(X,Z,U,alpha,gamma)( mdot(Z,X) + mdot(X,dat_C*X) + 0.5 * alpha* norm(X-U,'fro')^2 - 0.5*gamma*norm(Z,'fro')^2 ) ;
theta = L(X,Z,U,alpha,gamma) / d(X);
beta = 1;

for iter = 0:max_iter
    

    [tk_fobj,tk_subgrad] = topksum(X,k);
    grad = 2*dat_C*X + Z - theta*2*dat_D*X - rho*tk_subgrad;
    X = U - grad/alpha;
    X = OrthProj(X);
    U = (1-beta)*U + beta*X;
    Z1 = X/gamma;
    % Z = Prox(h*,1/gamma,Z1)
    % min_Z 0.5/mu ||Z-Z1||_F^2 + h*(Z)
    % min_Z 0.5/mu ||Z-Z1||_F^2, s.t. ||Z||_{\inf}<=rho
    Z = ProjBox(Z1,rho);
    theta = L(X,Z,U,alpha,gamma) / d(X);
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(X);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f \n',iter,true_fobj);
    end

    
end

