function demo_sharpe
clc;clear all;close all;
% This program solves the following optimization problem:
%
%         max(0,max(b-A*x))
% min_x ------------------,   s.t.   x>=0, sum(x)=1
%         max_i (x'*C_i*x)
%

clc;clear all;close all;
addpath('util','solver','data');
randn('seed',0); rand('seed',0);

timeIntervel = 0.1; % Record the objective value in every timeIntervel second

data_ids    = [1  2  3  4  5  6  7  8] ;
time_limits = [10 10 10 10 10 10 10 10]*0.3;

for id = 1:length(data_ids)
    fprintf('data: %d\n',id);
    data_id = data_ids(id);
    timeLimit = time_limits(id);
    
    [dat_A,dat_b] = SelectData1(data_id);
    [dat_A] = NormData(dat_A,2);
    [m,n] = size(dat_A);
    for i=1:100
        CCC = randn(n)*10;
        dat_Cs{i}=CCC*CCC'/n;
    end
    
    x0 = proj_simplex(rand(n,1)); % x0 = (1/n)*ones(n,1);
    max_iter = 100000;
    beta0 = 0.001;
    alg_xi = 0.5;
    [x1,fobjs1,ts1] = SubGrad(x0,dat_A,dat_b,dat_Cs,max_iter,alg_xi,timeIntervel,timeLimit);
    IsMultiplier = 0;
    [x2,fobjs2,ts2] = FADMM_D(x0,dat_A,dat_b,dat_Cs,max_iter,beta0,alg_xi,timeIntervel,timeLimit,IsMultiplier);
    [x3,fobjs3,ts3] = FADMM_Q(x0,dat_A,dat_b,dat_Cs,max_iter,beta0,alg_xi,timeIntervel,timeLimit,IsMultiplier);
    
    [x4,fobjs4,ts4] = FSA(x0,dat_A,dat_b,dat_Cs,max_iter,timeIntervel,timeLimit);
    [x5,fobjs5,ts5] = FSA2(x0,dat_A,dat_b,dat_Cs,max_iter,timeIntervel,timeLimit);
    
    IsMultiplier = 1;
    [x6,fobjs6,ts6] = FADMM_D(x0,dat_A,dat_b,dat_Cs,max_iter,beta0,alg_xi,timeIntervel,timeLimit,IsMultiplier);
    [x7,fobjs7,ts7] = FADMM_Q(x0,dat_A,dat_b,dat_Cs,max_iter,beta0,alg_xi,timeIntervel,timeLimit,IsMultiplier);
    
    all_fobj = [fobjs1;fobjs2;fobjs3;fobjs4;fobjs5;fobjs6;fobjs7];
    %     min_obj = min(all_fobj);
    
    %     fobjs1 = fobjs1 - min_obj;
    %     fobjs2 = fobjs2 - min_obj;
    %     fobjs3 = fobjs3 - min_obj;
    %     fobjs4 = fobjs4 - min_obj;
    %     fobjs5 = fobjs5 - min_obj;
    %     fobjs6 = fobjs6 - min_obj;
    %     fobjs7 = fobjs7 - min_obj;
    
    %     all_fobj = [fobjs1;fobjs2;fobjs3;fobjs4;fobjs5;fobjs6;fobjs7];
    
    figure('color','w');
    myplot = @semilogy;
    %     myplot = @plot;
    pcolor = loadcolor;
    
    myplot(ts1,fobjs1,'--kv','LineWidth',3,'MarkerSize',3,'color', pcolor.purple); hold on;
    myplot(ts2,fobjs2,'-.mo','LineWidth',3,'MarkerSize',3,'color',  pcolor.blue); hold on;
    myplot(ts3,fobjs3,'--kv','LineWidth',3,'MarkerSize',3,'color', pcolor.pink); hold on;
    myplot(ts4,fobjs4,'--x','LineWidth',3,'MarkerSize',3,'color', pcolor.orange); hold on;
    myplot(ts5,fobjs5,'-.d','LineWidth',3,'MarkerSize',3,'color', pcolor.crimson); hold on;
    myplot(ts6,fobjs6,'-.b^','LineWidth',3,'MarkerSize',3,'color', pcolor.green); hold on;
    myplot(ts7,fobjs7,'--s','LineWidth',3,'MarkerSize',3,'color', pcolor.red); hold on;
    
    %     grid on;
    hleg=legend('SPM','SPGM-D','SPGM-Q','FSA-I','FSA-II','FADMM-D','FADMM-Q');
    set(hleg,'FontSize',12,'FontWeight','normal');
    set(hleg,'Fontname','times new Roman');
    set(hleg,'Location','NorthEast');
    %     set(hleg,'Location','Best');
    set(gca,'Fontsize', 12);set(hleg, 'Color', 'none');% set(hleg, 'Box', 'off');
    
    xlabel('Time (seconds)','FontSize',12)
    ylabel('Objective','FontSize',12,'interpreter','latex')
    
    axis([0,timeLimit*1.01,min(all_fobj),max(all_fobj)]);
    
    fprintf('\n');
    set(gcf,'paperpositionmode','auto')
    print(sprintf('%s_%d.eps',mfilename,id),'-depsc2','-loose');
    print(sprintf('%s_%d.png',mfilename,id),'-dpng');
    %     print(sprintf('%s_%d.pdf',mfilename,id),'-dpdf', '-r0');
    
end


function [downs] = Compute_downs(x,dat_Cs)
for i=1:length(dat_Cs)
    downs(i) = x'*dat_Cs{i}*x;
end

function [x,fobjs,ts] = FADMM_D(x,dat_A,dat_b,dat_Cs,max_iter,beta0,alg_xi,timeIntervel,timeLimit,IsMultiplier)
%
%         max(0,max(b-Ax))
% min_x ------------------,   s.t.   x>=0, sum(x)=1
%         max_i (x'C_ix)
%

%
%         max(0,max(y))
% min_x ------------------,   s.t.   x>=0, sum(x)=1
%         max_i (x'C_ix)
% s.t. b-Ax = y

%                     max(0,max(y)) + <b-Ax-y,z> + 0.5*beta*norm(b-Ax-y)^2
% L(x,y,z,beta,mu) = ------------------------------------------------------
%                            max_i (x'C_ix)

xi = alg_xi;
theta = 1.1;
tau = 0.5;
% beta0 = 0.1;
p = 1/3;
sigma = 1.2;
alpha = (theta-1)/ ( (theta+1)*(1+tau+tau*xi) )   -       eps;sigma=1;alpha = 0;
chi = 2*(sigma/(2-sigma)) *  sqrt(1/sigma + xi/(sigma^2))    ;

[m,n] = size(dat_A);
normA = norm(full(dat_A));
% y = dat_A*x-dat_b;

y = randn(m,1)*0.01;

if(IsMultiplier==1)
    z = randn(m,1)*0.01;
    fprintf('FADMM_D: \n');
else
    z = randn(m,1)*0.0;
    fprintf('SPGM_D: \n');
end

x_old = x;

fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(x)ComputeTrueObj(x,dat_A,dat_b,dat_Cs);
fobjs = [fobjs;HandleObj(x)]; ts = [ts;etime(clock,initt)];


for iter = 0:max_iter
    true_fobj = ComputeTrueObj(x,dat_A,dat_b,dat_Cs);his(iter+1) = true_fobj;
    beta = beta0*(1+xi*iter^p);
    ellbeta = 0 + beta*normA^2;
    mu = chi/beta;
    xc = x + alpha*(x-x_old);
    x_old = x;
    
    if(IsMultiplier==1)
        ut = max_fun_mu(y,mu) + (dat_b-dat_A*x-y)'*z + 0.5*beta*norm(dat_b-dat_A*x-y)^2;
    else
        ut = max(0,max(y)) + (dat_b-dat_A*x-y)'*z + 0.5*beta*norm(dat_b-dat_A*x-y)^2;
    end
    
    downs_x = Compute_downs(x,dat_Cs);
    [down,index_max] = max(downs_x);
    lambda = ut / down;
    
    grad1 = -dat_A'*z - beta*dat_A'*(dat_b-dat_A*xc-y) - lambda*2*dat_Cs{index_max}*x;
    x1 = proj_simplex(xc - grad1 / (theta*ellbeta));
    
    
    downs_x1 = Compute_downs(x1,dat_Cs);
    [down_x1,index_max_1] = max(downs_x1);
    if(down > down_x1*tau)
        grad2 = -dat_A'*z - beta*dat_A'*(dat_b-dat_A*x-y) - lambda*2*dat_Cs{index_max_1}*x;
        x = proj_simplex(x - grad2 / (theta*ellbeta));
    else
        x = x1;
    end
    
    
    B = dat_b-dat_A*x + z/beta;
    % min_Y  [max(0,max(y))]_{\mu} + 0.5 beta ||y - b||_F^2
    if(IsMultiplier==1)
        y = smooth_prox_max(B,mu,beta);
        diff = dat_b-dat_A*x -y;
        z = z + sigma*beta*diff;
    else
        y = prox_max(B,1/beta);
        diff = dat_b-dat_A*x -y;
        z = z*0;
    end
    
    
    
    
    
    
    %     fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,true_fobj,norm(diff,'fro'),beta);
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(x);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,true_fobj,norm(diff,'fro'),beta);
    end
end


fprintf('\n');

function f = max_fun_mu(y,mu)
% max(0,max(y))
y_bar = prox_max(y,mu);
f = 0.5/mu*norm(y-y_bar,'fro')^2 +  max(0,max(y_bar));

function [x,fobjs,ts] = SPGM(x,dat_A,dat_b,dat_Cs,max_iter,beta0,alg_xi,timeIntervel,timeLimit)
%
%
%         max(0,max(b-Ax))
% min_x ------------------,   s.t.   x>=0, sum(x)=1
%         max_i (x'C_ix)
%

%
%         max(0,max(y))
% min_x ------------------,   s.t.   x>=0, sum(x)=1
%         max_i (x'C_ix)
% s.t. b-Ax = y

%                     max(0,max(y)) + <b-Ax-y,z> + 0.5*beta*norm(b-Ax-y)^2
% L(x,y,z,beta,mu) = ------------------------------------------------------
%                            max_i (x'C_ix)

xi = alg_xi;
theta = 1.1;
tau = 0.5;
% beta0 = 0.1;
p = 1/3;
sigma = 1.2;
alpha = (theta-1)/ ( (theta+1)*(1+tau+tau*xi) )   -       eps;sigma=1;alpha = 0;
chi = 2*(sigma/(2-sigma)) *  sqrt(1/sigma + xi/(sigma^2))    ;

[m,n] = size(dat_A);
normA = norm(full(dat_A));
% y = dat_A*x-dat_b;
y = rand(m,1)*0.01;
z = rand(m,1)*0.00;
x_old = x;

fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(x)ComputeTrueObj(x,dat_A,dat_b,dat_Cs);
fobjs = [fobjs;HandleObj(x)]; ts = [ts;etime(clock,initt)];
fprintf('SPGM: \n');

for iter = 0:max_iter
    beta = beta0*(1+xi*iter^p);
    ellbeta = 0 + beta*normA^2;
    mu = chi/beta;
    xc = x + alpha*(x-x_old);
    x_old = x;
    ut = max(0,max(y)) + (dat_b-dat_A*x-y)'*z + 0.5*beta*norm(dat_b-dat_A*x-y)^2;
    downs_x = Compute_downs(x,dat_Cs);
    [down,index_max] = max(downs_x);
    lambda = ut / down;
    
    grad1 = -dat_A'*z - beta*dat_A'*(dat_b-dat_A*xc-y) - lambda*2*dat_Cs{index_max}*x;
    x1 = proj_simplex(x - grad1 / (theta*ellbeta));
    
    
    downs_x1 = Compute_downs(x1,dat_Cs);
    [down_x1,index_max_1] = max(downs_x1);
    if(down > down_x1*tau)
        grad2 = -dat_A'*z - beta*dat_A'*(dat_b-dat_A*x-y) - lambda*2*dat_Cs{index_max_1}*x;
        x = proj_simplex(x - grad2 / (theta*ellbeta));
    else
        x = x1;
    end
    
    
    B = dat_b-dat_A*x + z/beta;
    % min_Y  [max(0,max(y))]_{\mu} + 0.5 beta_bar ||y - b||_F^2
    y = smooth_prox_max(B,mu,beta);
    
    diff = dat_b-dat_A*x -y;
    %     z = z + sigma*beta*diff;
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(x);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,true_fobj,norm(diff,'fro'),beta);
    end
end

fprintf('\n');


function [x,fobjs,ts] = FADMM_Q(x,dat_A,dat_b,dat_Cs,max_iter,beta0,alg_xi,timeIntervel,timeLimit,IsMultiplier)
%
%         max(0,max(b-Ax))
% min_x ------------------,   s.t.   x>=0, sum(x)=1
%         max_i (x'C_ix)
%

%
%         max(0,max(y))
% min_x ------------------,   s.t.   x>=0, sum(x)=1
%         max_i (x'C_ix)
% s.t. b-Ax = y

%                     max(0,max(y)) + <b-Ax-y,z> + 0.5*beta*norm(b-Ax-y)^2
% L(x,y,z,beta,mu) = ------------------------------------------------------
%                            max_i (x'C_ix)


xi = alg_xi;
theta = 1.1;
tau = 0.5;
% beta0 = 0.1;
p = 1/3;
sigma = 1.2;
alpha = (theta-1)/ ( (theta+1)*(1+tau+tau*xi) )   -       eps;sigma=1;alpha = 0;
chi = 2*(sigma/(2-sigma)) *  sqrt(1/sigma + xi/(sigma^2))    ;


[m,n] = size(dat_A);
normA = norm(full(dat_A));
% y = dat_A*x-dat_b;

y = randn(m,1)*0.01;
if(IsMultiplier==1)
    z = randn(m,1)*0.01;
    fprintf('FADMM_Q: \n');
else
    z = randn(m,1)*0.0;
    fprintf('SPGM_Q: \n');
end

x_old = x;
lambda_t=0;

fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(x)ComputeTrueObj(x,dat_A,dat_b,dat_Cs);
fobjs = [fobjs;HandleObj(x)]; ts = [ts;etime(clock,initt)];

for iter = 0:max_iter
    true_fobj = ComputeTrueObj(x,dat_A,dat_b,dat_Cs); his(iter+1) = true_fobj;
    beta = beta0*(1+xi*iter^p);
    ellbeta = 0 + beta*normA^2;
    mu = chi/beta;
    xc = x + alpha*(x-x_old);
    x_old = x;
    
    
    if(IsMultiplier==1)
        ut = max_fun_mu(y,mu) + (dat_b-dat_A*x-y)'*z + 0.5*beta*norm(dat_b-dat_A*x-y)^2;
    else
        ut = max(0,max(y)) + (dat_b-dat_A*x-y)'*z + 0.5*beta*norm(dat_b-dat_A*x-y)^2;
    end
    
    downs = Compute_downs(x,dat_Cs);
    [dt,index_max] = max(downs);
    lambda_t1 = sqrt(dt)/ut;
    grad1 = -dat_A'*z - beta*dat_A'*(dat_b-dat_A*xc-y) - (2/lambda_t1)*0.5*dt^(-0.5)*2*dat_Cs{index_max}*x;
    x1 = proj_simplex(xc - grad1 / (theta*ellbeta));
    
    if(lambda_t1^2 > lambda_t^2*tau)
        grad2 = -dat_A'*z - beta*dat_A'*(dat_b-dat_A*x-y) - (2/lambda_t1)*0.5*dt^(-0.5)*2*dat_Cs{index_max}*x;
        x = proj_simplex(x - grad2 / (theta*ellbeta));
    else
        x = x1;
    end
    lambda_t = lambda_t1;
    
    
    B = dat_b-dat_A*x + z/beta;
    % min_Y  [max(0,max(y))]_{\mu} + 0.5 beta ||y - b||_F^2
    if(IsMultiplier==1)
        y = smooth_prox_max(B,mu,beta);
        diff = dat_b-dat_A*x -y;
        z = z + sigma*beta*diff;
    else
        y = prox_max(B,1/beta);
        diff = dat_b-dat_A*x -y;
        z = z*0;
    end
    
    %     fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,true_fobj,norm(diff,'fro'),beta);
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(x);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,true_fobj,norm(diff,'fro'),beta);
    end
end


fprintf('\n');

function [x,fobjs,ts] = SubGrad(x,dat_A,dat_b,dat_Cs,max_iter,alg_xi,timeIntervel,timeLimit)
%
%         max(0,max(b-Ax))
% min_x ------------------,   s.t.   x>=0, sum(x)=1
%         max_i (x'C_ix)
%
xi = alg_xi;
beta0 = 10;
p = 1/3;

fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(x)ComputeTrueObj(x,dat_A,dat_b,dat_Cs);
fobjs = [fobjs;HandleObj(x)]; ts = [ts;etime(clock,initt)];
fprintf('SubGrad: \n');
for iter = 0:max_iter
    beta = beta0*(1+xi*iter^p);
    %      beta = iter+1;
    [up0,index_up] = max(dat_b-dat_A*x);
    up = max(0,up0);
    downs = Compute_downs(x,dat_Cs);
    [down,index_down] = max(downs);
    fobj = up / down;
    
    
    grad_up = -dat_A(index_up,:)'*(dat_b(index_up)-dat_A(index_up,:)*x);
    grad_down = 2*dat_Cs{index_down}*x;
    subgrad = (grad_up*down - up*grad_down) / (down^2);
    
    x = proj_simplex(x - subgrad / beta);
    %     true_fobj = ComputeTrueObj(x,dat_A,dat_b,dat_Cs);
    %     fprintf('iter:%d, fobj:%f\n',iter,true_fobj);
    %     his(iter+1) = true_fobj;
    
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(x);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f, beta:%f\n',iter,true_fobj,beta);
    end
    
end

fprintf('\n');

function fobj = ComputeTrueObj(x,dat_A,dat_b,dat_Cs)
%
%         max(0,max(b-Ax))
% min_x ------------------,   s.t.   x>=0, sum(x)=1
%         max_i (x'C_ix)
%

x = proj_simplex(x);
up = max(0,max(dat_b-dat_A*x));
downs = Compute_downs(x,dat_Cs);
down = max(downs);
fobj = up / down;

function y = smooth_prox_max(b,mu,beta)
% min_Y [max(0,max(y))]_{\mu} + 0.5 beta ||y - b||_F^2
y_bar = prox_max(b,mu+1/beta);
y =  b/ ( 1/(beta*mu) + 1 ) + y_bar / (1 + beta*mu)    ;


function [x,fobjs,ts] = FSA(x,dat_A,dat_b,dat_Cs,max_iter,timeIntervel,timeLimit)
%
%           max(b-Ax)
% min_x ------------------,   s.t.   x>=0, sum(x)=1
%         max_i (x'C_ix)
%

fprintf('FSA \n');
fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(x)ComputeTrueObj(x,dat_A,dat_b,dat_Cs);
% fobjs = [fobjs;HandleObj(X)]; ts = [ts;etime(clock,initt)];

% h(x) = max(x)
% h*(z)=  delta_{S} (z), where S = { x | x>=0, sum(x)=1}

alpha = 1000;
gamma = 1/alpha;
[m,n] = size(dat_A);
u = rand(n,1)*0.01;
z = rand(m,1)*0.01;

d = @(x) max(Compute_downs(x,dat_Cs));

L = @(x,z,u,alpha,gamma) (mdot(z,dat_b-dat_A*x) + 0.5 * alpha* norm(x-u,'fro')^2 - 0.5*gamma*norm(z,'fro')^2 );
theta = L(x,z,u,alpha,gamma) / d(x);
beta = 1.8;

for iter = 0:max_iter
    
    downs_x = Compute_downs(x,dat_Cs);
    [~,index_max] = max(downs_x);
    subg = 2*dat_Cs{index_max}*x;
    grad = -dat_A'*z - theta*subg;
    x = u - grad/alpha;
    x = proj_simplex(x);
    u = (1-beta)*u + beta*x;
    z1 = (dat_b-dat_A*x)/gamma;
    % Z = Prox(h*,1/gamma,Z1)
    % min_Z 0.5/mu ||z-z1||_F^2 + h*(z)
    % min_Z 0.5/mu ||z-Z1||_F^2, s.t. z \in S
    z = proj_simplex(z1);
    
    theta = L(x,z,u,alpha,gamma) / d(x);
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(x);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f \n',iter,true_fobj);
    end
    
    
end


function [x,fobjs,ts] = FSA2(x,dat_A,dat_b,dat_Cs,max_iter,timeIntervel,timeLimit)
%
%           max(b-Ax)
% min_x ------------------,   s.t.   x>=0, sum(x)=1
%         max_i (x'C_ix)
%

fprintf('FSA \n');
fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(x)ComputeTrueObj(x,dat_A,dat_b,dat_Cs);
% fobjs = [fobjs;HandleObj(X)]; ts = [ts;etime(clock,initt)];

% h(x) = max(x)
% h*(z)=  delta_{S} (z), where S = { x | x>=0, sum(x)=1}

alpha = 10000;
gamma = 1/alpha;
[m,n] = size(dat_A);
u = rand(n,1)*0.01;
z = rand(m,1)*0.01;

d = @(x) max(Compute_downs(x,dat_Cs));

L = @(x,z,u,alpha,gamma) (mdot(z,dat_b-dat_A*x) + 0.5 * alpha* norm(x-u,'fro')^2 - 0.5*gamma*norm(z,'fro')^2 );
theta = L(x,z,u,alpha,gamma) / d(x);
beta = 1.8;

for iter = 0:max_iter
    
    downs_x = Compute_downs(x,dat_Cs);
    [~,index_max] = max(downs_x);
    subg = 2*dat_Cs{index_max}*x;
    grad = -dat_A'*z - theta*subg;
    x = u - grad/alpha;
    x = proj_simplex(x);
    u = (1-beta)*u + beta*x;
    z1 = (dat_b-dat_A*x)/gamma;
    % Z = Prox(h*,1/gamma,Z1)
    % min_Z 0.5/mu ||z-z1||_F^2 + h*(z)
    % min_Z 0.5/mu ||z-Z1||_F^2, s.t. z \in S
    z = proj_simplex(z1);
    
    theta = L(x,z,u,alpha,gamma) / d(x);
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(x);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f \n',iter,true_fobj);
    end
    
    
end

