function [x,fobjs,ts] = SparseRecovery_Smoothing(x,A,NormA,b,R,max_iter,beta0,timeIntervel,timeLimit)
% min_x ||x||_{0.5}^{0.5}, ||Ax-b||_1 <= R
% min_{x,y} ||x||_{0.5}^{0.5}, Ax - b = y, ||y||_1 <= R
% L(x,y;beta) = ||x||_{0.5}^{0.5} + <Ax-b-y,z> + 0.5 beta ||Ax-b-y||_2^2

initt = clock;
last_rec_clock = initt;
HandleObj = @(x) SparseRecovery_ComputeObj(x,A,b,R);


beta = beta0;
[theta1,alpha1,sigma,theta2,alpha2,xi] = FindSuitableParametersCaseA(A);

[m,n] = size(A);


y = A*x - b;
y = projectL2(y,R);
z = randn(m,1)*0;
y_bar = y;
x_bar = x;

ts = []; fobjs = [];
fobj = HandleObj(x);
fobjs = [fobjs;fobj];
ts = [ts;etime(clock,initt)];


for iter = 1:max_iter
    % L(x,y;beta) = ||x||_{0.5}^{0.5} + <Ax-b-y,z> + 0.5 beta ||Ax-b-y||_2^2
    grad_x = A'*z + beta*A'*(A*x-b-y);
    Lx = beta*NormA^2;
    x_old = x;
    x = prox_lp(x_bar - grad_x / Lx,Lx*theta1);
    
    % L(x,y;beta) = ||x||_{0.5}^{0.5} + <Ax-b-y,z> + 0.5 beta ||Ax-b-y||_2^2
    grad_y = -z + beta*(y+b-A*x);
    Ly = beta;
    y_old = y;
    %     y = proj_l1(y_bar - grad_y/(Ly*theta2),R);
    y =  y_bar - grad_y/(Ly*theta2);
    y = proj_l2(y,R);
    
    %    dddd(iter) =  norm(x,0.5)^0.5 + mdot(A*x-b-y,z) + 0.5*beta*norm(A*x-b-y)^2;
    
    
    % Update Z
    diff = A*x-b-y;
    %    z = z + sigma*beta*diff;
    
    y_bar = y + alpha1 * (y - y_old);
    x_bar = x + alpha2 * (x - x_old);
    
    e = norm(diff,'fro');
    
    if(~mod(iter,20))
        beta = beta * sqrt(sqrt(2));
    end

    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        fobj = HandleObj(x);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit
            break;
        end
        fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,fobj,e,beta);
    end
    
    
end
