function demo_rsr_10_1
clc;clear all;close all;
% This program solves the following optimization problem:
%
%         alpha ||Ax-b||_1 + lambda ||x||_1
% min_x --------------------------------
%                 ||x||_[k]
%

clc;clear all;close all;
addpath('util','solver','data');
randn('seed',1); rand('seed',1);

dat_alpha = 100;
dat_lambda = 10;

timeIntervel = 0.8; % Record the objective value in every timeIntervel second

data_ids    = [1  2  3  4  5  6  7  8 ];
time_limits = [10 10 10 10 10 10 10 10 ]*2;



for id = 1:length(data_ids)
    data_id = data_ids(id);
    timeLimit = time_limits(id);
    [dat_A,dat_b] = SelectData1(data_id);
    [m,n] = size(dat_A);
    dat_A = NormData(dat_A,0);

    % Note: we scale both A and b, this is because
    % min_x (alpha ||Ax-b||_1 + lambda ||x||_1 ) / ||x||_[k]
    % is equvalent to
    % min_x (|| (alpha*A)*x-(alpha*b)||_1 + lambda ||x||_1 ) / ||x||_[k]
    dat_A = dat_alpha*dat_A; 
    dat_b = dat_alpha*dat_b;
    
    R = inf;
    x0 = randn(n,1)*1;
    x0 = min(R,max(-R,x0));
    dat_k = round(0.1*n);
    
    max_iter = 1e15;
    [x1,fobjs1,ts1] = SubGrad(x0,dat_A,dat_b,dat_k,dat_lambda,R,max_iter,10,timeIntervel,timeLimit);
    [x2,fobjs2,ts2] = FSA(x0,dat_A,dat_b,dat_k,dat_lambda,R,max_iter,timeIntervel,timeLimit);
    [x3,fobjs3,ts3] = FSA2(x0,dat_A,dat_b,dat_k,dat_lambda,R,max_iter,timeIntervel,timeLimit);
    beta0 = 0.001/dat_alpha;
    alg_xi = 0.5;
    IsMultiplier = 0;
    [x4,fobjs4,ts4] = FADMM_D(x0,dat_A,dat_b,dat_k,dat_lambda,R,max_iter,alg_xi,beta0,timeIntervel,timeLimit,IsMultiplier);
    IsMultiplier = 1;
    [x5,fobjs5,ts5] = FADMM_D(x0,dat_A,dat_b,dat_k,dat_lambda,R,max_iter,alg_xi,beta0,timeIntervel,timeLimit,IsMultiplier);
    
    tt0 = 2;
    fobjs1 = fobjs1(tt0:end); fobjs2 = fobjs2(tt0:end); fobjs3 = fobjs3(tt0:end); fobjs4 = fobjs4(tt0:end);fobjs5 = fobjs5(tt0:end);
    ts1 = ts1(tt0:end); ts2 = ts2(tt0:end); ts3 = ts3(tt0:end); ts4 = ts4(tt0:end); ts5 = ts5(tt0:end);
    
    figure('color','w');
    myplot = @semilogy;
    pcolor = loadcolor;
    myplot(ts1,fobjs1,':ko','LineWidth',3,'MarkerSize',3,'color', pcolor.purple); hold on;
    myplot(ts2,fobjs2,'--x','LineWidth',3,'MarkerSize',3,'color', pcolor.orange); hold on;
    myplot(ts3,fobjs3,'-.d','LineWidth',3,'MarkerSize',3,'color', pcolor.crimson); hold on;
    myplot(ts4,fobjs4,':m*','LineWidth',3,'MarkerSize',3,'color', pcolor.green); hold on;
    myplot(ts5,fobjs5,'-.+','LineWidth',3,'MarkerSize',3,'color', pcolor.red); hold on;
    
    %    myplot(ts5,fobjs5,'--+','LineWidth',5,'MarkerSize',3,'color', pcolor.crimson); hold on;
    %    myplot(ts6,fobjs6,'-+','LineWidth',5,'MarkerSize',3,'color', pcolor.orange); hold on;
    %
    %grid on;
    hleg=legend('SPM','FSA-I','FSA-II','SPGM-D','FADMM-D');%,'FADMM-QT'
    set(hleg,'FontSize',12,'FontWeight','normal');
    set(hleg,'Fontname','times new Roman');
%     set(hleg,'Location','NorthWest');
    set(hleg,'Location','NorthEast');
    set(gca,'Fontsize', 12);set(hleg, 'Color', 'none');% set(hleg, 'Box', 'off');
    xlabel('Time (seconds)','FontSize',12)
    ylabel('Objective','FontSize',12,'interpreter','latex')
    all_fobj = [fobjs1;fobjs2;fobjs3;fobjs4;fobjs5]; %
    
    axis([0,timeLimit+1.01,min(all_fobj),max(all_fobj)]); %fobjs4(1)
    fprintf('\n');
    set(gcf,'paperpositionmode','auto')
    print(sprintf('%s_%d.eps',mfilename,id),'-depsc2','-loose');
    print(sprintf('%s_%d.png',mfilename,id),'-dpng');
    %     print(sprintf('%s_%d.pdf',mfilename,id),'-dpdf', '-r0');
    pause(0.1)
    close all;
    pause(0.1)
end


function [x,fobjs,ts] = FADMM_D(x,dat_A,dat_b,dat_k,dat_lambda,R,max_iter,alg_xi,beta0,timeIntervel,timeLimit,IsMultiplier)
%
%         ||Ax-b||_1 + lambda ||x||_1
% min_x --------------------------------
%                ||x||_[k]
%

%
%         ||y||_1 + lambda ||x||_1
% min_x --------------------------------
%                 ||x||_[k]
%
% s.t. Ax-b = y

%                     ||y||_1 + lambda ||x||_1 + <Ax-b-y,z> + 0.5*beta*norm(Ax-b-y)^2
% L(x,y,z,beta,mu) = ------------------------------------------------------
%                                          ||x||_[k]


dat_lambda2 = 1;
xi = alg_xi;
theta = 1.01;
tau = 0.5;
% beta0 = 100;
p = 1/3;
sigma = 1.2;
alpha = (theta-1)/ ((theta+1)*(1+tau+tau*xi)) - 1e-5;
sigma=1;alpha = 0;
chi = 2*sigma*sqrt(1/sigma + xi/(sigma^2))   /   (2-sigma);

[m,n] = size(dat_A);
normA = norm(full(dat_A));


if(IsMultiplier==1)
    z = randn(m,1)*0.01;
    fprintf('FADMM_D: \n');
else
    z = randn(m,1)*0.00;
    fprintf('SPGM_D: \n');
end


% initial the solution y
y = randn(m,1)*0.01;
% y = smooth_prox_l1(dat_A*x-dat_b,0.001,1000);


x_old = x;
fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(x)ComputeTrueObj(x,dat_A,dat_b,dat_k,dat_lambda);
fobjs = [fobjs;HandleObj(x)]; ts = [ts;etime(clock,initt)];

%                     ||y||_1 + lambda ||x||_1 + 0.5*beta*norm(Ax-b-y)^2
% L(x,y,z,beta,mu) = ------------------------------------------------------
%                                         norm(x)

for iter = 0:max_iter
    
    beta = beta0*(1+xi*iter^p);
    ellbeta = beta*normA^2;
    mu = chi/beta;
    xc = x + alpha*(x-x_old);
    x_old = x;
    
    %L1_norm_mu(y,mu)
    if(IsMultiplier==1)
        ut = norm(y,1)  + dat_lambda*norm(x,1) + (dat_A*x-dat_b-y)'*z  + 0.5*beta*norm(dat_A*x-dat_b-y)^2;
    else
        ut = norm(y,1) + dat_lambda*norm(x,1) + (dat_A*x-dat_b-y)'*z  + 0.5*beta*norm(dat_A*x-dat_b-y)^2;
    end
    
    
    [down,subgrad_down] = topksum(x,dat_k);
    down = down*dat_lambda2;
    subgrad_down = subgrad_down*dat_lambda2;
    if(down<1e-5)
        down = 1e-5;
        subgrad_down = x*0;
    end
    lambda = ut / down;
    grad1 =  beta*dat_A'*(dat_A*xc-dat_b-y) + dat_A'*z  - lambda*subgrad_down;
    x1 = prox_l1(xc - grad1 / (theta*ellbeta), dat_lambda / (theta*ellbeta) );
    
    [down_x1] = topksum(x1,dat_k);
    if(down_x1<1e-5)
        down_x1 = 1e-5;
    end
    if(down > down_x1*tau)
        grad2 = dat_A'*z + beta*dat_A'*(dat_A*x-dat_b-y) - lambda*subgrad_down;
        x = prox_l1(x - grad2 / (theta*ellbeta), dat_lambda / (theta*ellbeta));
    else
        x = x1;
    end
    
    
    B = dat_A*x-dat_b + z/beta;
    % min_Y  [max(0,max(y))]_{\mu} + 0.5 beta_bar ||y - b||_F^2
    
    if(IsMultiplier==1)
        y = smooth_prox_l1(B,mu,beta);
        diff = dat_A*x - dat_b - y;
        z = z + sigma*beta*diff;
    else
        y = prox_l1(B,1/beta);
        diff = dat_A*x - dat_b - y;
        z = z*0;
    end

    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(x);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,true_fobj,norm(diff,'fro'),beta);
    end
end


fprintf('\n');




function [x,fobjs,ts] = FADMM_QT(x,dat_A,dat_b,dat_k,dat_lambda,R,max_iter,beta0,timeIntervel,timeLimit)
%
%         ||Ax-b||_1 + lambda ||x||_1
% min_x --------------------------------
%                lambda2*||x||_[k]
%

%
%         ||y||_1 + lambda ||x||_1
% min_x --------------------------------
%                lambda2* ||x||_[k]
%
% s.t. Ax-b = y

%                     ||y||_1 + lambda ||x||_1 + <Ax-b-y,z> + 0.5*beta*norm(Ax-b-y)^2
% L(x,y,z,beta,mu) = ------------------------------------------------------
%                                          lambda2*||x||_[k]


dat_lambda2 = 1;
xi = 0.01;
theta = 1.01;
tau = 0.5;
% beta0 = 100;
p = 1/3;
sigma = 1.2;
alpha = (theta-1)/ ((theta+1)*(1+tau+tau*xi)) - eps;

chi = 2*sigma*sqrt(1/sigma + xi/(sigma^2))   /   (2-sigma);

[m,n] = size(dat_A);
normA = norm(full(dat_A));

y = rand(m,1)*0.01;
z = rand(m,1)*0.01;
x_old = x;

fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(x)ComputeTrueObj(x,dat_A,dat_b,dat_k,dat_lambda);
fobjs = [fobjs;HandleObj(x)]; ts = [ts;etime(clock,initt)];
fprintf('FADMM-QT:\n');


%                     ||y||_1 + lambda ||x||_1 + 0.5*beta*norm(Ax-b-y)^2
% L(x,y,z,beta,mu) = ------------------------------------------------------
%                                         norm(x)
lambda_t = 0;

for iter = 0:max_iter
    
    beta = beta0*(1+xi*iter^p);
    ellbeta = beta*normA^2;
    mu = chi/beta;
    xc = x + alpha*(x-x_old);
    x_old = x;
    ut = norm(y,1) + dat_lambda*norm(x,1) + (dat_A*x-dat_b-y)'*z  + 0.5*beta*norm(dat_A*x-dat_b-y)^2;
    [dt,subgrad_down] = topksum(x,dat_k);
    if(dt<1e-5)
        dt = 1e-5;
        subgrad_down = x*0;
    end
    dt = dt*dat_lambda2;
    subgrad_down = subgrad_down*dat_lambda2;
    
    lambda_t1 = sqrt(dt) / ut;
    grad1 = beta*dat_A'*(dat_A*xc-dat_b-y) + dat_A'*z  - (2/lambda_t1)*0.5*dt^(-0.5)*subgrad_down;
    x1 = prox_l1(xc - grad1 / (theta*ellbeta), dat_lambda / (theta*ellbeta) );
    
    if(lambda_t1^2 > lambda_t^2*tau)
        grad1 =  beta*dat_A'*(dat_A*x-dat_b-y) + dat_A'*z  - (2/lambda_t1)*0.5*dt^(-0.5)*subgrad_down;
        x = prox_l1(x - grad1 / (theta*ellbeta), dat_lambda / (theta*ellbeta) );
    else
        x = x1;
    end
    
    lambda_t = lambda_t1;
    
    
    B = dat_A*x-dat_b + z/beta;
    % min_Y  [max(0,max(y))]_{\mu} + 0.5 beta_bar ||y - b||_F^2
    y = smooth_prox_l1(B,mu,beta);
    
    diff = dat_A*x - dat_b - y;
    z = z + sigma*beta*diff;
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(x);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,true_fobj,norm(diff,'fro'),beta);
    end
end


fprintf('\n');

function [x,fobjs,ts] = SubGrad(x,dat_A,dat_b,dat_k,dat_lambda,R,max_iter,beta0,timeIntervel,timeLimit)
%
%         ||Ax-b||_1 + lambda ||x||_1
% min_x --------------------------------
%                 ||x||
dat_lambda_2 = 1;
% proj = @(x) min(R,max(-R,x));
xi = 10;
% beta0 = 1000;
p = 1/3;

fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(x)ComputeTrueObj(x,dat_A,dat_b,dat_k,dat_lambda);
fobjs = [fobjs;HandleObj(x)]; ts = [ts;etime(clock,initt)];
fprintf('SubGrad:\n');

for iter = 0:max_iter
    beta = beta0*(1+xi*iter^p); % bad!
    
    
    err = dat_A*x - dat_b;
    up = norm(err,1) + dat_lambda*norm(err,1);
    
    [down,grad_down] = topksum(x,dat_k);
    if(down<1e-5)
        down = 1e-5;
        grad_down = x*0;
    end
    
    down  = down*dat_lambda_2;
    grad_down  = grad_down*dat_lambda_2;
    
    
    grad_up = dat_A'*sign(err) + dat_lambda*sign(x);
    subgrad = (grad_up*down - up*grad_down) / (  down^2);
    x=x - subgrad / beta;
    
    %     x = proj(x - subgrad / beta);
    
    %     true_fobj = ComputeTrueObj(x,dat_A,dat_b,dat_Cs);
    %     fprintf('iter:%d, fobj:%f\n',iter,true_fobj);
    %     his(iter+1) = true_fobj;
    
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(x);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f, beta:%f\n',iter,true_fobj,beta);
    end
    
end

fprintf('\n');

function fobj = ComputeTrueObj(x,dat_A,dat_b,dat_k,lambda)
%
%         ||Ax-b||_1 + lambda ||x||_1
% min_x --------------------------------
%               ||x||

err = dat_A*x-dat_b;
up = norm(err,1) + lambda * norm(x,1);
down = topksum(x,dat_k);
if(down<1e-5)
    down = 1e-5;
end
fobj = up / down;


function Y = smooth_prox_l1(B,mu,beta)
% min_Y  [||Y||_1]_{\mu} + 0.5 beta ||Y - B||_F^2
y_bar = prox_l1(B,mu+1/beta);
Y =  B/ ( 1/(beta*mu) + 1 )   +   y_bar / (1 + beta*mu)    ;

function [x] = prox_l1(a,lambda)
% It solves the following OP:
% min_{x} 0.5||x-a||^2 + lambda * sum(abs(x))
x = sign(a).*max(0,abs(a)-lambda);



function [x,fobjs,ts] = FSA(x,dat_A,dat_b,dat_k,dat_lambda,R,max_iter,timeIntervel,timeLimit)
%
%         ||Ax-b||_1 + lambda ||x||_1
% min_x --------------------------------
%                ||x||_[k]
%


fprintf('FSA \n');
fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(x)ComputeTrueObj(x,dat_A,dat_b,dat_k,dat_lambda);
% fobjs = [fobjs;HandleObj(X)]; ts = [ts;etime(clock,initt)];

% h(x) = rho ||x||_1
% h*(z)=  delta_{||z||_{\inf}<=rho}(z)
[m,n] = size(dat_A);
alpha = 1000;
gamma = 1/alpha;
z = randn(m,1)*0.01;
u = randn(n,1)*0.01;
d = @(x)topksum(x,dat_k);
L = @(x,z,u,alpha,gamma)( mdot(z,dat_A*x-dat_b) + 0.5 * alpha* norm(x-u,'fro')^2 - 0.5*gamma*norm(z,'fro')^2 ) ;
theta = L(x,z,u,alpha,gamma) / d(x);
beta = 1.8;

for iter = 0:max_iter
    
    [tk_fobj,tk_subgrad] = topksum(x,dat_k);
    grad = dat_A'*z - theta*tk_subgrad;
    a = u - grad/alpha;
    % x = min_x \lambda ||x||_1 + 0.5 alpha || x - a ||_2^2
    % x = min_x \lambda/alpha ||x||_1 + 0.5  || x - a ||_2^2
    x = prox_l1(a,dat_lambda/alpha);
    u = (1-beta)*u + beta*x;
    z1 = (dat_A*x-dat_b)/gamma;
    z = ProjBox(z1,1);
    theta = L(x,z,u,alpha,gamma)/d(x);
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(x);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f \n',iter,true_fobj);
    end
    
    
end

function [x,fobjs,ts] = FSA2(x,dat_A,dat_b,dat_k,dat_lambda,R,max_iter,timeIntervel,timeLimit)
%
%         ||Ax-b||_1 + lambda ||x||_1
% min_x --------------------------------
%                ||x||_[k]
%


fprintf('FSA2 \n');
fobjs = []; ts = [];
initt = clock;
last_rec_clock = initt;
HandleObj = @(x)ComputeTrueObj(x,dat_A,dat_b,dat_k,dat_lambda);
% fobjs = [fobjs;HandleObj(X)]; ts = [ts;etime(clock,initt)];

% h(x) = rho ||x||_1
% h*(z)=  delta_{||z||_{\inf}<=rho}(z)
[m,n] = size(dat_A);
alpha = 10000;
gamma = 1/alpha;
z = randn(m,1)*0.01;
u = randn(n,1)*0.01;
d = @(x)topksum(x,dat_k);
L = @(x,z,u,alpha,gamma)( mdot(z,dat_A*x-dat_b) + 0.5 * alpha* norm(x-u,'fro')^2 - 0.5*gamma*norm(z,'fro')^2 ) ;
theta = L(x,z,u,alpha,gamma) / d(x);
beta = 1.8;

for iter = 0:max_iter
    
    [tk_fobj,tk_subgrad] = topksum(x,dat_k);
    grad = dat_A'*z - theta*tk_subgrad;
    a = u - grad/alpha;
    % x = min_x \lambda ||x||_1 + 0.5 alpha || x - a ||_2^2
    % x = min_x \lambda/alpha ||x||_1 + 0.5  || x - a ||_2^2
    x = prox_l1(a,dat_lambda/alpha);
    u = (1-beta)*u + beta*x;
    z1 = (dat_A*x-dat_b)/gamma;
    z = ProjBox(z1,1);
    theta = L(x,z,u,alpha,gamma)/d(x);
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        true_fobj = HandleObj(x);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;true_fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
        fprintf('iter:%d, fobj:%f \n',iter,true_fobj);
    end
    
    
end
