function [theta1,alpha1,sigma,theta2,alpha2,xi] = FindSuitableParametersCaseI_stoc(qqq,bbb)
eps1 = 0.01; eps2 = 0.01; eps3 = 0.0001;

%% Choose parameters the the n-1 block
eps0 = 1e-12;
% theta - 1 - (2+eps1) alpha theta > eps0
% theta - 1 - eps0  > (2+eps1) alpha theta
choose_alpha1 = @(theta)(theta-1-eps0) / ((2+eps1)*(theta));
theta1 = 1.05;
alpha1 = choose_alpha1(theta1);

%%  Choose parameters for the last block
choose_alpha2 = @(theta)(theta-1)/((2+eps1)*(1+theta)) * (1-eps1);
theta2 = 1.001;
alpha2 = choose_alpha2(theta2);
gamma = 0.5*( theta2 - 1 - (2+eps1)*alpha2*theta2 );
sigma = 1.5;
sigma1 = sigma / ( (1 - abs(1-sigma))^2);

%% Choose delta and check feasibility
delta = 1 + eps2;
alpha_n_plus = (1+eps1)*alpha2^2;
chi = (1+eps3)*theta2;
gamma_plus =  gamma*(1-eps3) - eps3/2 - eps3*qqq/(2*bbb) ;
if(8*sigma1*delta*(1+eps3)*( (chi-1)^2  + alpha_n_plus * chi^2 ) - gamma_plus>0)
    8*sigma1*delta*(1+eps3)*( (chi-1)^2  + alpha_n_plus * chi^2 ) - gamma_plus
    
    error('NO!');
end

xi = min(eps1,eps2*sigma);
