function [X,fobjs,ts] = L0SPCA_SubGrad(X,A,const,rho,k,max_iter,timeIntervel,timeLimit)
% min_X  -0.5/m*mdot(A,A*X*X') + const + rho (||X||_1 - ||X||_{topk} ), s.t. X'X = I
[m,n] = size(A);

initt = clock;
last_rec_clock = initt;
HandleObj = @(X) L0SPCA_ComputeObj(X,A,rho,k,const,m);


r = size(X,2);
bottom = n*r - k;
X = OrthProj(X);

ts = []; fobjs = [];
fobj = HandleObj(X);
fobjs = [fobjs;fobj];
ts = [ts;etime(clock,initt)];


for iter = 1:max_iter
    [~,SubGrad1] = BottomK(X,bottom);
    
    SubGrad = -1/m*A'*(A*X) + rho*SubGrad1;
    X = X - 0.1*SubGrad / iter;  
    X = OrthProj(X);

    
        cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        fobj = HandleObj(X);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit
            break;
        end
        fprintf('iter:%d, fobj:%f\n',iter,fobj);
    end
    
    
end

