function [X,fobjs,ts] = L0SPCA_IPL_ADMM_stoc(X,A,NormA,const,rho,k,max_iter,beta0,timeIntervel,timeLimit)
% min_X -0.5*mdot(A,A*X*X') + const + rho ( ||X||_1 - ||X||_{topk} ), s.t. X'X = I
% min_X  -0.5*mdot(A,A*X*X') + const + rho ( ||X||_1 - ||X||_{topk} ), s.t. X'X = I
% min_X  -0.5*mdot(A,A*X*X') + const + rho ( ||X||_1 - ||X||_{topk} ), s.t. Y = X, Y'Y = I
% L(X,Y,Z) = -0.5*mdot(A,A*X*X') + const + rho ( ||X||_1 - ||X||_{topk} ) + <Y-X,Z> + 0.5 beta ||Y-X||_F^2, s.t. Y'Y = I

initt = clock;
last_rec_clock = initt;

[m,n] = size(A);
r = size(X,2);
Y = X;
Z = randn(n,r)*1;

qqq = round(sqrt(m));
bbb = round(sqrt(m));

HandleObj = @(X) L0SPCA_ComputeObj(X,A,rho,k,const,m);

[theta1,alpha1,sigma,theta2,alpha2,xi] = FindSuitableParametersCaseI_stoc(qqq,bbb);



beta = beta0;
Y_bar = Y;
X_bar = X;


ts = []; fobjs = [];
fobj = HandleObj(X);
fobjs = [fobjs;fobj];
ts = [ts;etime(clock,initt)];

grad_bat = zeros(size(X));

for iter = 0:max_iter
    
    grad_bat_old = grad_bat;
    grad_bat = MiniBatchGradL0SPCA(A,randperm(m,bbb),X);    
    if (mod(iter,qqq)==0)
        v = - 1/(2*m)*A'*(A*X);
    else
        v = v + grad_bat - grad_bat_old;
    end
    
    % Update Y
    % L(X,Y,Z) =  0.5*trace(X'*H*X) + rho ( ||X||_1 - ||X||_{topk} )  + <Y-X,Z> + 0.5 beta ||Y-X||_F^2, s.t. Y'Y = I
    % min_Y <Y-X,Z> + 0.5 beta ||Y-X||_F^2, s.t. Y'Y = I
    % min_Y 0.5 beta ||Y-X+Z/beta||_F^2, s.t. Y'Y = I
    %     0.5*trace(X'*H*X) + rho* ( norm(X(:),1) - topksum(X(:),k) ) + mdot(Y-X,Z) + 0.5*beta*fnorm(Y-X)^2;
    grad_Y = Z + beta*(Y-X);
    Ly = beta;
    Y_old = Y;
    Y = OrthProj(Y_bar - grad_Y/(theta1*Ly));
    
    % Update X
    % L(X,Y,Z) = 0.5*trace(X'*H*X) + rho ( ||X||_1 - ||X||_{topk} )  + <Y-X,Z> + 0.5 beta ||Y-X||_F^2, s.t. Y'Y = I
    % 0.5 L ||X-Xt||_F^2 + <X-Xt,grad>  + rho ( ||X||_1 - ||X||_{topk} )
    % 0.5 L ||X-Xt + grad/L||_F^2 + rho ( ||X||_1 - ||X||_{topk} )
    %     0.5*trace(X'*H*X) + rho* ( norm(X(:),1) - topksum(X(:),k) ) + mdot(Y-X,Z) + 0.5*beta*fnorm(Y-X)^2;
    grad_X = v - Z + beta*(X-Y);
    Lx = NormA^2 + beta;
    X_old = X;
    X = prox_l1topk(X_bar - grad_X/ (Lx*theta2),(Lx*theta2),rho,k);
    
    % Update Z
    diff = Y-X;
    Z = Z + sigma*beta*diff;
    
    Y_bar = Y + alpha1 * (Y - Y_old);
    X_bar = X + alpha2 * (X - X_old);
    
    e = norm(diff,'fro');
    beta = AdaptivePenaltyUpdateRule(beta,beta0,e,xi,iter);
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        fobj = HandleObj(X);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit
            break;
        end
        fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,fobj,e,beta);
    end
end
