function X = prox_l1topk(C,alpha,rho,k)
% min_x 0.5 alpha || X - C ||_2^2 + rho (||X||_1  -  ||X||_{topk})
X = prox_l1topk_vec(C(:),alpha,rho,k);
X = reshape(X,size(C));

function [x] = prox_l1topk_vec(c,alpha,rho,k)
% min_x 0.5 beta || x - c ||_2^2 + rho (||x||_1  -  |x|_{topk})
s = length(c) - k;
x = c;
[~,ind] = sort(abs(c),'ascend');
ind = ind(1:s);
x(ind) = prox_l1(c(ind),rho/alpha);