% %{
% function test_prox_max
% rand('seed',0);
% randn('seed',0);
% n = 10;
% 
% 
% while 1
% a = -rand(n,1)*100;
% 
% lambda = rand(1)*100;
% fx = @(x)0.5*(x-a)'*(x-a) + lambda * max(0,max(x));
% 
% cvx_begin
%    variable x(n,1)
%    minimize (0.5*(x-a)'*(x-a) + lambda * max(x) )
% cvx_end
% x1 = x;
% x2 = prox_max(a,lambda);
% 
% 
% % cvx_begin 
% % cvx_precision high
% %    variables y(n,1)
% %    minimize (0.5*(y-a)'*(y-a) )
% %    y>=0
% %    sum(y)==lambda
% % cvx_end
% % x = a-y;
% % x2 = x;
%  
% 
% if(fx(x1)<fx(x2))
%     a
%     x1
%     x2
%     fx(x1) - fx(x2)
%     dddd
% end
% 
% end
% %\}


function [x] = prox_max_(a,lambda)
% It solves the following OP:
% min_{x} 0.5||x-a||^2 + lambda * max(max(x),0)

%minimize (0.5*(x-a)'*(x-a) + lambda * max(x) )

% fx = @(x)0.5*(x-a)'*(x-a) + lambda * max(x);

y = ProjectOntoSimplex(a,lambda);
x = a - y;
   
   
function w = ProjectOntoSimplex(v, b)
% PROJECTONTOSIMPLEX Projects point onto simplex of specified radius.
%
% w = ProjectOntoSimplex(v, b) returns the vector w which is the solution
%   to the following constrained minimization problem:
%
%    min   ||w - v||_2
%    s.t.  sum(w) = b, w >= 0.
%
%   That is, performs Euclidean projection of v to the positive simplex of
%   radius b.
%
% Author: John Duchi (jduchi@cs.berkeley.edu)

if (b < 0)
  error('Radius of simplex is negative: %2.3f\n', b);
end
v = (v > 0) .* v;
u = sort(v,'descend');
sv = cumsum(u);
rho = find(u > (sv - b) ./ (1:length(u))', 1, 'last');
% theta = max(0, (sv(rho) - b) / rho);
theta = (sv(rho) - b) / rho;
w = max(v - theta, 0);

