#PACKAGES -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

using Optim, Plots, DelimitedFiles, LinearAlgebra, Random, StatsBase, FiniteDifferences, LaTeXStrings , EasyFit, Printf, FFTW, Pkg, Noise, Clustering, Dierckx, BSplineKit, MultivariateStats, Flux, Combinatorics, Bigsimr, DataFrames, JLD

#FUNCTIONS -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#Functions for optimization and compute expectation of the cost function
cd(@__DIR__)#to go back to the directory of the script
include("../MyFunctions/myFunctions_NeurIPS_2025.jl")

#DEFINITION OF THE PROBLEM -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#TASK PARAMETERS -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

println("\n------- NEW RUN ---------------------------------------------------- \n")

#PROBLEM PARAMETERS -- Reaching Task (with high dimensioal controller) 3D REACHING TASK
dimension_of_state = 6
dimension_of_control = 6
dimension_of_observation = dimension_of_state
dimension_of_latent_space_ext_LSC = dimension_of_state 

Δt = 0.010 #seconds
T = 100

#Initial conditions (mean state and state estimate, and their covariances) -- Note that initial state and state estimate are considered to be uncorrelated at t=1 (initial time step)
#Mean initial state and state estimates -- Note that we assume <x_1> = <z_1>
target_position_mean_x = 2.0
target_position_mean_y = 1.0
target_position_mean_z = 2.5
#note that x_state_0 is the initial mean state of the vector
x_state_mean_0 = zeros(dimension_of_state) #meters. 
x_state_mean_0[1] = target_position_mean_x 
x_state_mean_0[2] = target_position_mean_y
x_state_mean_0[3] = target_position_mean_z
x_state_mean_0[4:end] = 0.00001*ones(dimension_of_state-3) 
x_state_estimate_mean_0 = zeros(dimension_of_state)
x_state_estimate_mean_0[:] .= x_state_mean_0[:]

#State covariance 
Σ_1_x = Diagonal(zeros(dimension_of_state)) #intial covariance of the state
#State estimate covariance --- NOTE THAT THESE VARIABLES HAVE TO BE ZERO (OTHERWISE CHANGE THE NSC APPROACH ACCORDINGLY!)
Σ_1_z = Diagonal(zeros(dimension_of_state)) #intial covariance of the state estimate
#auxialiary variables 
x_1_mean = deepcopy(x_state_mean_0)
z_1_mean = deepcopy(x_state_estimate_mean_0)   

#Matrices of the problem 

# State transition matrix A (positions integrate velocities)
A = [
    1.0 0.0 0.0  Δt 0.0 0.0;
    0.0 1.0 0.0  0.0 Δt 0.0;
    0.0 0.0 1.0  0.0 0.0 Δt;
    0.0 0.0 0.0  1.0 0.0 0.0;
    0.0 0.0 0.0  0.0 1.0 0.0;
    0.0 0.0 0.0  0.0 0.0 1.0]

# Control projection matrix B
B = Matrix(I, dimension_of_state, dimension_of_control) # B is the identity matrix (control affects all states)

# Observation matrix H (only observe position)
H = [
    1.0 0.0 0.0 0.0 0.0 0.0;
    0.0 1.0 0.0 0.0 0.0 0.0;
    0.0 0.0 1.0 0.0 0.0 0.0;
    0.0 0.0 0.0 1.0 0.0 0.0;
    0.0 0.0 0.0 0.0 1.0 0.0;
    0.0 0.0 0.0 0.0 0.0 1.0]

σ_ξ = 0.5 
σ_ω_add_sensory_noise = 0.5 
σ_ρ_mult_sensory_noise = 0.5 
σ_ϵ_mult_control_noise = 0.5 

σ_η_internal_noise = 0.0
σ_η_internal_noise_vec = σ_η_internal_noise .*ones(dimension_of_state) 

Ω_ξ = Diagonal(σ_ξ .* ones(dimension_of_state)) 
Ω_ω = Diagonal(σ_ω_add_sensory_noise .* ones(dimension_of_state, dimension_of_state))
Ω_η = Diagonal(σ_η_internal_noise_vec) 

C = σ_ϵ_mult_control_noise .* B
D = σ_ρ_mult_sensory_noise .* H

R_matrix = zeros(dimension_of_control, dimension_of_control, T)
r_val = 0.0001
for i in 1:T-1
    R_matrix[:,:,i] .=  Diagonal(r_val .* ones(dimension_of_control, dimension_of_control))
end

Q_matrix = zeros(dimension_of_state, dimension_of_state, T)
# for i in 1:T-1
#     Q_matrix[:,:,i] .= Diagonal([0.1, 0.1, 0.1, 1.0, 1.0, 1.0])
# end
Q_matrix[:,:,end] .= Diagonal([10.0, 10.0, 10.0, 1.0, 1.0, 1.0])

#OPTIMIZATION PARAMETERS ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#Todorov's algorithm
N_iter_Todorov = 100

#Numerical GD algorithm
algorithm_GD = GradientDescent()
#iterations_GD = 5000
iterations_GD = 50000
# Specify options for the optimization algorithm
options_GD = Optim.Options(
    # Step size for gradient descent
    iterations = iterations_GD,  # Number of iterations
    store_trace = false   # Show optimization trace
)

#Optimization with Lagrange multipliers method 
N_iterations_Lagrange = 100

#Neural Space Control (NSC) ---- here also referred to as "LSC" (Latent Space Control)
N_iterations_LSC = 100
N_iterations_LSC_each_dir = 1 #this is the number of iterations for each direction of the coordinate descent

#Montecarlo simulations parameters 
num_trials_MC_runs = 50000
random_seed_MC = rand(1:1000000)

#TODOROV OPTIMIZATION -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

println("\n------- (1) Todorov's optimization --------------------------\n")

L_TOD, K_TOD = Todorov_optimization_multidimensional_case(A, B, H, C, D, T, dimension_of_state, dimension_of_control, dimension_of_observation, x_state_mean_0, Σ_1_x, Σ_1_z, Q_matrix, R_matrix, Ω_ξ, Ω_ω, Ω_η, N_iter_Todorov)

#Expected cost using moments propagation
expected_cost_mom_prop_TOD = expected_cost_raw_moments_propagation(T, dimension_of_state, dimension_of_control, dimension_of_observation, K_TOD, L_TOD, A, B, H, C, D, x_1_mean, z_1_mean, Σ_1_x, Σ_1_z, Q_matrix, R_matrix, Ω_ξ, Ω_ω, Ω_η)
#Expected cost using Todorov's algorithm
expected_cost_TOD_alg_TOD = expected_cost_using_Todorov(L_TOD, K_TOD, A, B, H, C, D, T, dimension_of_state, x_state_mean_0, Σ_1_x, Q_matrix, R_matrix, Ω_ξ, Ω_ω, Ω_η)
#Expected cost using trace formula [Trace formula proved by induction]
expected_cost_TOD_using_trace_formula = expected_cost_using_trace_formula_induction(L_TOD, K_TOD, A, B, H, C, D, T, dimension_of_state, x_state_mean_0, x_state_mean_0, Σ_1_x, Σ_1_z, Q_matrix, R_matrix, Ω_ξ, Ω_ω, Ω_η)

println("- Expected cost using moment propagation (Todorov): $expected_cost_mom_prop_TOD\n")
println("- Expected cost using Todorov's algorithm (Todorov):$expected_cost_TOD_alg_TOD\n")
println("- Expected cost using trace formula (Todorov):$expected_cost_TOD_using_trace_formula\n")

#LAGRANGE MULTIPLIER OPTIMIZATION -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

println("\n------- (2) Lagrange multipliers optimization ---------------\n")

K_initial = zeros(dimension_of_state, dimension_of_observation, T - 1)
L_initial = zeros(dimension_of_control, dimension_of_state, T - 1)
#Initial conditions for the parameters to be optimized
K_initial[:,:,:] .= K_TOD[:,:,:]
L_initial[:,:,:] .= L_TOD[:,:,:]

#Lagrange multipliers optimization
K_matrix_Lag_Mul_whole, L_matrix_Lag_Mul_whole, cost_mom_prop_Lag_Mul_whole = Optimal_Control_Estimation_with_Lagrange_Multipliers(N_iterations_Lagrange, dimension_of_state, dimension_of_control, dimension_of_observation, K_initial, L_initial, A, B, H, C, D, Ω_ξ, Ω_ω, Ω_η, Q_matrix, R_matrix, Σ_1_x, Σ_1_z, x_1_mean, z_1_mean)

#Expected cost using moments propagation
expected_cost_mom_prop_Lag_Mul_whole = expected_cost_raw_moments_propagation(T, dimension_of_state, dimension_of_control, dimension_of_observation, K_matrix_Lag_Mul_whole, L_matrix_Lag_Mul_whole, A, B, H, C, D, x_1_mean, z_1_mean, Σ_1_x, Σ_1_z, Q_matrix, R_matrix, Ω_ξ, Ω_ω, Ω_η)
#Expected cost using Todorov's algorithm
expected_cost_TOD_alg_Lag_Mul_whole = expected_cost_using_Todorov(L_matrix_Lag_Mul_whole, K_matrix_Lag_Mul_whole, A, B, H, C, D, T, dimension_of_state, x_state_mean_0, Σ_1_x, Q_matrix, R_matrix, Ω_ξ, Ω_ω, Ω_η)
#Expected cost using trace formula [our formula proved by induction]
expected_cost_Lag_Mul_whole_using_trace_formula = expected_cost_using_trace_formula_induction(L_matrix_Lag_Mul_whole, K_matrix_Lag_Mul_whole, A, B, H, C, D, T, dimension_of_state, x_state_mean_0, x_state_mean_0, Σ_1_x, Σ_1_z, Q_matrix, R_matrix, Ω_ξ, Ω_ω, Ω_η)

println("- Expected cost using moment propagation (Lag_Mul_whole): $expected_cost_mom_prop_Lag_Mul_whole\n")
println("- Expected cost using Todorov's algorithm (Lag_Mul_whole):$expected_cost_TOD_alg_Lag_Mul_whole\n")
println("- Expected cost using trace formula (Lag_Mul_whole):$expected_cost_Lag_Mul_whole_using_trace_formula\n")

#EXTENDED LATENT SPACE CONTROL -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

println("\n------- (3) Neural Space Control (NSC), p = $dimension_of_latent_space_ext_LSC ---------------------------\n")

K_initial_LSC = zeros(dimension_of_latent_space_ext_LSC, dimension_of_observation, T-1)
M_initial_LSC = zeros(dimension_of_latent_space_ext_LSC, dimension_of_latent_space_ext_LSC, T-1)
L_initial_LSC = zeros(dimension_of_control, dimension_of_latent_space_ext_LSC, T-1)

#Initial conditions for the parameters to be optimized -- same as optimal condition only if dimension_of_latent_space_ext_LSC = dimension_of_control
K_initial_LSC[:,:,:] .= K_matrix_Lag_Mul_whole[:,:,:]
L_initial_LSC[:,:,:] .= L_matrix_Lag_Mul_whole[:,:,:]

for i in 1:T-1
    M_initial_LSC[:,:,i] .= A .+ B*L_matrix_Lag_Mul_whole[:,:,i] .- K_matrix_Lag_Mul_whole[:,:,i]*H #to match with Todorov's solution
end

#alternative ICs
# m_0 = 0.1
# k_0 = 0.2
# l_0 = -1e-1
# L_initial_LSC[:,:,1] = l_0 .* Matrix(I, dimension_of_control, dimension_of_latent_space_ext_LSC)
# for i in 1:T-1
#     M_initial_LSC[:,:,i] .= m_0 .* Diagonal(ones(dimension_of_latent_space_ext_LSC, dimension_of_latent_space_ext_LSC))
#     K_initial_LSC[:, :, i] .= k_0 .* Matrix(I, dimension_of_latent_space_ext_LSC, dimension_of_observation)
# end
# for i in 2:T-1
#     L_initial_LSC[:,:,i] .= l_0 .* Matrix(I, dimension_of_control, dimension_of_latent_space_ext_LSC)
# end

z_1_mean_LSC =  zeros(dimension_of_latent_space_ext_LSC)

#z_1_mean_LSC[:] .= pinv(B*L_initial_LSC[:,:,1])*B*L_matrix_Lag_Mul_whole[:,:,1]*z_1_mean #to match with Todorov's solution [when dimension_of_latent_space != dimension_of_control we'll have to optimize for the initial condition as well!!!]
z_1_mean_LSC[:] .= z_1_mean

#Lagrange multipliers optimization, NOTE that first time steo is not optimized (same as Estimation Control Solution)
K_matrix_LSC, M_matrix_LSC, L_matrix_LSC, cost_mom_prop_LSC, cost_trace_formula_LSC = Optimal_EXTENDED_Latent_Space_and_Input_with_Lagrange_Multipliers_COORDINATE_DESCENT(N_iterations_LSC, N_iterations_LSC_each_dir, dimension_of_state, dimension_of_latent_space_ext_LSC, dimension_of_observation, dimension_of_control, K_initial_LSC, M_initial_LSC, L_initial_LSC, A, B, H, C, D, Ω_ξ, Ω_ω, Ω_η, Q_matrix, R_matrix, Σ_1_x, Σ_1_z, x_1_mean, z_1_mean_LSC)

expected_cost_mom_prop_LSC = cost_mom_prop_LSC[end]
expected_cost_using_trace_formula_LSC = cost_trace_formula_LSC[end]

println("- Expected cost using moment propagation (LSC): $expected_cost_mom_prop_LSC\n")
println("- Expected cost using trace formula (LSC):$expected_cost_using_trace_formula_LSC\n")
