#PACKAGES -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

using Optim, Plots, DelimitedFiles, LinearAlgebra, Random, StatsBase, FiniteDifferences, LaTeXStrings , EasyFit, Printf, FFTW, Pkg, Noise, Clustering, Dierckx, BSplineKit, MultivariateStats, Flux, Combinatorics, Bigsimr, DataFrames, JLD, Base.Threads

#FUNCTIONS -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#Functions for optimization and compute expectation of the cost function
cd(@__DIR__)#to go back to the directory of the script
include("../MyFunctions/myFunctions_NeurIPS_2025.jl")

#DEFINITION OF THE PROBLEM -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#TASK PARAMETERS -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

println("\n------- NEW RUN ---------------------------------------------------- \n")

#PROBLEM PARAMETERS -- Reaching Task (with high dimensioal controller) 3D REACHING TASK
dimension_of_state = 6
dimension_of_control = 6
dimension_of_observation = dimension_of_state
dimension_of_latent_space_ext_LSC = dimension_of_state 

Δt = 0.010 #seconds
T = 100 #time steps

#Initial conditions (mean state and state estimate, and their covariances) -- Note that initial state and state estimate are considered to be uncorrelated (initial time step)
#Mean initial state and state estimates -- Note that we assume <x_1> = <z_1>
target_position_mean_x = 1.5
target_position_mean_y = 1.0
target_position_mean_z = 2.5
#note that x_state_0 is the initial mean state of the vector
x_state_mean_0 = zeros(dimension_of_state) #meters. 
x_state_mean_0[1] = target_position_mean_x 
x_state_mean_0[2] = target_position_mean_y
x_state_mean_0[3] = target_position_mean_z
x_state_mean_0[4:end] = 0.00001*ones(dimension_of_state-3) 
x_state_estimate_mean_0 = zeros(dimension_of_state)
x_state_estimate_mean_0[:] .= x_state_mean_0[:]

#State covariance 
Σ_1_x = Diagonal(zeros(dimension_of_state)) #intial covariance of the state
#State estimate covariance --- NOTE THAT THESE VARIABLES HAVE TO BE ZERO (OTHERWISE CHANGE THE NSC APPROACH ACCORDINGLY!)
Σ_1_z = Diagonal(zeros(dimension_of_state)) #intial covariance of the state estimate
#auxialiary variables 
x_1_mean = deepcopy(x_state_mean_0)
z_1_mean = deepcopy(x_state_estimate_mean_0)   

#Matrices of the problem 

# State transition matrix A (positions integrate velocities)
A = [
    1.0 0.0 0.0  Δt 0.0 0.0;
    0.0 1.0 0.0  0.0 Δt 0.0;
    0.0 0.0 1.0  0.0 0.0 Δt;
    0.0 0.0 0.0  1.0 0.0 0.0;
    0.0 0.0 0.0  0.0 1.0 0.0;
    0.0 0.0 0.0  0.0 0.0 1.0]

# Control projection matrix B
B = Matrix(I, dimension_of_state, dimension_of_control) # B is the identity matrix (control affects all states)

# Observation matrix H (only observe position)
H = [
    1.0 0.0 0.0 0.0 0.0 0.0;
    0.0 1.0 0.0 0.0 0.0 0.0;
    0.0 0.0 1.0 0.0 0.0 0.0;
    0.0 0.0 0.0 1.0 0.0 0.0;
    0.0 0.0 0.0 0.0 1.0 0.0;
    0.0 0.0 0.0 0.0 0.0 1.0]

σ_ξ = 0.5 
σ_ω_add_sensory_noise = 0.5 
σ_ρ_mult_sensory_noise = 0.4 
σ_ϵ_mult_control_noise = 0.4 

σ_η_internal_noise_levels = [0.0, 0.1, 0.3, 0.4, 0.5, 1.0, 2.0] 

Ω_ξ = Diagonal(σ_ξ .* ones(dimension_of_state)) 
Ω_ω = Diagonal(σ_ω_add_sensory_noise .* ones(dimension_of_state, dimension_of_state))

C = σ_ϵ_mult_control_noise .* B
D = σ_ρ_mult_sensory_noise .* H

R_matrix = zeros(dimension_of_control, dimension_of_control, T)
r_val = 0.0001
for i in 1:T-1
    R_matrix[:,:,i] .=  Diagonal(r_val .* ones(dimension_of_control, dimension_of_control))
end

Q_matrix = zeros(dimension_of_state, dimension_of_state, T)
# for i in 1:T-1
#     Q_matrix[:,:,i] .= Diagonal([0.1, 0.1, 0.1, 1.0, 1.0, 1.0])
# end
Q_matrix[:,:,end] .= Diagonal([10.0, 10.0, 10.0, 1.0, 1.0, 1.0])

#OPTIMIZATION PARAMETERS ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#Todorov's algorithm
N_iter_Todorov = 100

#Numerical GD algorithm
algorithm_GD = GradientDescent()
#iterations_GD = 5000
iterations_GD = 50000
# Specify options for the optimization algorithm
options_GD = Optim.Options(
    # Step size for gradient descent
    iterations = iterations_GD,  # Number of iterations
    store_trace = false   # Show optimization trace
)

#Optimization with Lagrange multipliers method 
N_iterations_Lagrange = 100

#Neural Space Control (NSC) -- here also referred to as "LSC" (Latent Space Control)
N_iterations_LSC = 100
N_iterations_LSC_each_dir = 1 #this is the number of iterations for each direction of the coordinate descent

#ITERATE OVER DIFFERENT LEVELS OF INTERNAL NOISE ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

L_TOD_internal_noise = zeros(length(σ_η_internal_noise_levels), dimension_of_control, dimension_of_state, T - 1)
K_TOD_internal_noise = zeros(length(σ_η_internal_noise_levels), dimension_of_state, dimension_of_observation, T - 1)

expected_cost_mom_prop_TOD_internal_noise = zeros(length(σ_η_internal_noise_levels))
expected_cost_TOD_alg_TOD_internal_noise = zeros(length(σ_η_internal_noise_levels))
expected_cost_TOD_using_trace_formula_internal_noise = zeros(length(σ_η_internal_noise_levels))

L_matrix_Lag_Mul_whole_internal_noise = zeros(length(σ_η_internal_noise_levels), dimension_of_control, dimension_of_latent_space_ext_LSC, T - 1)
K_matrix_Lag_Mul_whole_internal_noise = zeros(length(σ_η_internal_noise_levels), dimension_of_latent_space_ext_LSC, dimension_of_observation, T - 1)

expected_cost_mom_prop_Lag_Mul_whole_internal_noise = zeros(length(σ_η_internal_noise_levels))
expected_cost_TOD_alg_Lag_Mul_whole_internal_noise = zeros(length(σ_η_internal_noise_levels))
expected_cost_Lag_Mul_whole_using_trace_formula_internal_noise = zeros(length(σ_η_internal_noise_levels))

L_matrix_LSC_internal_noise = zeros(length(σ_η_internal_noise_levels), dimension_of_control, dimension_of_latent_space_ext_LSC, T - 1)
M_matrix_LSC_internal_noise = zeros(length(σ_η_internal_noise_levels), dimension_of_latent_space_ext_LSC, dimension_of_latent_space_ext_LSC, T - 1)
K_matrix_LSC_internal_noise = zeros(length(σ_η_internal_noise_levels), dimension_of_latent_space_ext_LSC, dimension_of_observation, T - 1)

expected_cost_mom_prop_LSC_internal_noise = zeros(length(σ_η_internal_noise_levels))
expected_cost_using_trace_formula_LSC_internal_noise = zeros(length(σ_η_internal_noise_levels))

convergence_cost_LSC_mom_prop = zeros(length(σ_η_internal_noise_levels), 3*N_iterations_LSC*N_iterations_LSC_each_dir+1)
convergence_cost_LSC_trace_formula = zeros(length(σ_η_internal_noise_levels), 3*N_iterations_LSC*N_iterations_LSC_each_dir+1)

@threads for i in 1:length(σ_η_internal_noise_levels)
    
    println("i = $i")
    
    σ_η_internal_noise = σ_η_internal_noise_levels[i]
    σ_η_internal_noise_vec = σ_η_internal_noise .*ones(dimension_of_state) #internal noise acting on the state estimate (position, velocity, force, filtered control)
    Ω_η = Diagonal(σ_η_internal_noise_vec) #Internal noise is acting only on the osberved variables (position, velocity: visual feedbacks; force: proprioception)

    #println("\n------- (0) Todorov's optimization --------------------------\n")
    L_TOD, K_TOD = Todorov_optimization_multidimensional_case(A, B, H, C, D, T, dimension_of_state, dimension_of_control, dimension_of_observation, x_state_mean_0, Σ_1_x, Σ_1_z, Q_matrix, R_matrix, Ω_ξ, Ω_ω, Ω_η, N_iter_Todorov)
    L_TOD_internal_noise[i, :, :, :] .= L_TOD[:,:,:]
    K_TOD_internal_noise[i, :, :, :] .= K_TOD[:,:,:]

    #Expected cost using moments propagation
    expected_cost_mom_prop_TOD_internal_noise[i] = expected_cost_raw_moments_propagation(T, dimension_of_state, dimension_of_control, dimension_of_observation, K_TOD, L_TOD, A, B, H, C, D, x_1_mean, z_1_mean, Σ_1_x, Σ_1_z, Q_matrix, R_matrix, Ω_ξ, Ω_ω, Ω_η)
    #Expected cost using Todorov's algorithm
    expected_cost_TOD_alg_TOD_internal_noise[i] = expected_cost_using_Todorov(L_TOD, K_TOD, A, B, H, C, D, T, dimension_of_state, x_state_mean_0, Σ_1_x, Q_matrix, R_matrix, Ω_ξ, Ω_ω, Ω_η)
    #Expected cost using trace formula [our formula proved by induction]
    expected_cost_TOD_using_trace_formula_internal_noise[i] = expected_cost_using_trace_formula_induction(L_TOD, K_TOD, A, B, H, C, D, T, dimension_of_state, x_state_mean_0, x_state_mean_0, Σ_1_x, Σ_1_z, Q_matrix, R_matrix, Ω_ξ, Ω_ω, Ω_η)

    #println("\n------- (1) EC (Estimation Control) optimization --------------------------\n")
    K_initial = zeros(dimension_of_state, dimension_of_observation, T - 1)
    L_initial = zeros(dimension_of_control, dimension_of_state, T - 1)
    #Initial conditions for the parameters to be optimized
    K_initial[:,:,:] .= K_TOD[:,:,:]
    L_initial[:,:,:] .= L_TOD[:,:,:]

    #Lagrange multipliers optimization
    K_matrix_Lag_Mul_whole, L_matrix_Lag_Mul_whole, cost_mom_prop_Lag_Mul_whole = Optimal_Control_Estimation_with_Lagrange_Multipliers(N_iterations_Lagrange, dimension_of_state, dimension_of_control, dimension_of_observation, K_initial, L_initial, A, B, H, C, D, Ω_ξ, Ω_ω, Ω_η, Q_matrix, R_matrix, Σ_1_x, Σ_1_z, x_1_mean, z_1_mean)

    L_matrix_Lag_Mul_whole_internal_noise[i, :, :, :] .= L_matrix_Lag_Mul_whole[:,:,:]
    K_matrix_Lag_Mul_whole_internal_noise[i, :, :, :] .= K_matrix_Lag_Mul_whole[:,:,:]

    #Expected cost using moments propagation
    expected_cost_mom_prop_Lag_Mul_whole_internal_noise[i] = expected_cost_raw_moments_propagation(T, dimension_of_state, dimension_of_control, dimension_of_observation, K_matrix_Lag_Mul_whole, L_matrix_Lag_Mul_whole, A, B, H, C, D, x_1_mean, z_1_mean, Σ_1_x, Σ_1_z, Q_matrix, R_matrix, Ω_ξ, Ω_ω, Ω_η)
    #Expected cost using Todorov's algorithm
    expected_cost_TOD_alg_Lag_Mul_whole_internal_noise[i] = expected_cost_using_Todorov(L_matrix_Lag_Mul_whole, K_matrix_Lag_Mul_whole, A, B, H, C, D, T, dimension_of_state, x_state_mean_0, Σ_1_x, Q_matrix, R_matrix, Ω_ξ, Ω_ω, Ω_η)
    #Expected cost using trace formula [our formula proved by induction]
    expected_cost_Lag_Mul_whole_using_trace_formula_internal_noise[i] = expected_cost_using_trace_formula_induction(L_matrix_Lag_Mul_whole, K_matrix_Lag_Mul_whole, A, B, H, C, D, T, dimension_of_state, x_state_mean_0, x_state_mean_0, Σ_1_x, Σ_1_z, Q_matrix, R_matrix, Ω_ξ, Ω_ω, Ω_η)

    #println("\n------- (3) NSC optimization --------------------------\n")
    K_initial_LSC = zeros(dimension_of_latent_space_ext_LSC, dimension_of_observation, T-1)
    M_initial_LSC = zeros(dimension_of_latent_space_ext_LSC, dimension_of_latent_space_ext_LSC, T-1)
    L_initial_LSC = zeros(dimension_of_control, dimension_of_latent_space_ext_LSC, T-1)

    #Initial conditions for the parameters to be optimized -- same as optimal condition only if dimension_of_latent_space_ext_LSC = dimension_of_control
    K_initial_LSC[:,:,:] .= K_matrix_Lag_Mul_whole[:,:,:]
    L_initial_LSC[:,:,:] .= L_matrix_Lag_Mul_whole[:,:,:]

    for i in 1:T-1
        M_initial_LSC[:,:,i] .= A .+ B*L_matrix_Lag_Mul_whole[:,:,i] .- K_matrix_Lag_Mul_whole[:,:,i]*H #to match with Todorov's solution
    end

    K_matrix_LSC, M_matrix_LSC, L_matrix_LSC, cost_mom_prop_LSC, cost_trace_formula_LSC = Optimal_EXTENDED_Latent_Space_and_Input_with_Lagrange_Multipliers_COORDINATE_DESCENT(N_iterations_LSC, N_iterations_LSC_each_dir, dimension_of_state, dimension_of_latent_space_ext_LSC, dimension_of_observation, dimension_of_control, K_initial_LSC, M_initial_LSC, L_initial_LSC, A, B, H, C, D, Ω_ξ, Ω_ω, Ω_η, Q_matrix, R_matrix, Σ_1_x, Σ_1_z, x_1_mean, z_1_mean)

    L_matrix_LSC_internal_noise[i, :, :, :] .= L_matrix_LSC[:,:,:]
    M_matrix_LSC_internal_noise[i, :, :, :] .= M_matrix_LSC[:,:,:]
    K_matrix_LSC_internal_noise[i, :, :, :] .= K_matrix_LSC[:,:,:]

    convergence_cost_LSC_mom_prop[i, :] .= cost_mom_prop_LSC[:]
    convergence_cost_LSC_trace_formula[i, :] .= cost_trace_formula_LSC[:]

    #Expected cost using moments propagation
    expected_cost_mom_prop_LSC_internal_noise[i] = cost_mom_prop_LSC[end]
    #Expected cost using trace formula [our formula proved by induction]
    expected_cost_using_trace_formula_LSC_internal_noise[i] = cost_trace_formula_LSC[end]

end

###SAVE THE DATA ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

cd(@__DIR__)#to go back to the directory of the script
folder_location = "../New_Data/NSC_3D_Reaching_Task"

# Create a dictionary to store the matrices
Data_dict = Dict(
    "dimension_of_state" => dimension_of_state,
    "dimension_of_control" => dimension_of_control,
    "dimension_of_observation" => dimension_of_observation,
    "dimension_of_latent_space_ext_LSC" => dimension_of_latent_space_ext_LSC,
    "Δt" => Δt,
    "T" => T,
    "target_position_mean_x" => target_position_mean_x,
    "target_position_mean_y" => target_position_mean_y,
    "target_position_mean_z" => target_position_mean_z,
    "x_state_mean_0" => x_state_mean_0,
    "x_state_estimate_mean_0" => x_state_estimate_mean_0,
    "Σ_1_x" => Σ_1_x,
    "Σ_1_z" => Σ_1_z,
    "x_1_mean" => x_1_mean,
    "z_1_mean" => z_1_mean,
    "A" => A,
    "B" => B,
    "H" => H,
    "σ_ξ" => σ_ξ,
    "σ_ω_add_sensory_noise" => σ_ω_add_sensory_noise,
    "σ_ρ_mult_sensory_noise" => σ_ρ_mult_sensory_noise,
    "σ_ϵ_mult_control_noise" => σ_ϵ_mult_control_noise,
    "σ_η_internal_noise_levels" => σ_η_internal_noise_levels,
    "Ω_ξ" => Ω_ξ,
    "Ω_ω" => Ω_ω,
    "C" => C,
    "D" => D,
    "R_matrix" => R_matrix,
    "Q_matrix" => Q_matrix,
    "L_TOD_internal_noise" => L_TOD_internal_noise,
    "K_TOD_internal_noise" => K_TOD_internal_noise,
    "expected_cost_mom_prop_TOD_internal_noise" => expected_cost_mom_prop_TOD_internal_noise,
    "expected_cost_TOD_alg_TOD_internal_noise" => expected_cost_TOD_alg_TOD_internal_noise,
    "expected_cost_TOD_using_trace_formula_internal_noise" => expected_cost_TOD_using_trace_formula_internal_noise,
    "L_matrix_Lag_Mul_whole_internal_noise" => L_matrix_Lag_Mul_whole_internal_noise,
    "K_matrix_Lag_Mul_whole_internal_noise" => K_matrix_Lag_Mul_whole_internal_noise,
    "expected_cost_mom_prop_Lag_Mul_whole_internal_noise" => expected_cost_mom_prop_Lag_Mul_whole_internal_noise,
    "expected_cost_TOD_alg_Lag_Mul_whole_internal_noise" => expected_cost_TOD_alg_Lag_Mul_whole_internal_noise,
    "expected_cost_Lag_Mul_whole_using_trace_formula_internal_noise" => expected_cost_Lag_Mul_whole_using_trace_formula_internal_noise,
    "L_matrix_LSC_internal_noise" => L_matrix_LSC_internal_noise,
    "M_matrix_LSC_internal_noise" => M_matrix_LSC_internal_noise,
    "K_matrix_LSC_internal_noise" => K_matrix_LSC_internal_noise,
    "expected_cost_mom_prop_LSC_internal_noise" => expected_cost_mom_prop_LSC_internal_noise,
    "expected_cost_using_trace_formula_LSC_internal_noise" => expected_cost_using_trace_formula_LSC_internal_noise,
    "convergence_cost_LSC_mom_prop" => convergence_cost_LSC_mom_prop,
    "convergence_cost_LSC_trace_formula" => convergence_cost_LSC_trace_formula,
    "N_iterations_LSC" => N_iterations_LSC,
    "N_iterations_LSC_each_dir" => N_iterations_LSC_each_dir,
    "Q_matrix" => Q_matrix,
    "R_matrix" => R_matrix,
)

# Specify the file path
file_name_save_Data_dict = "NSC_3D_Reaching_Task_new.jld2"
file_path_save_Data_dict = folder_location * "/" *file_name_save_Data_dict

# Save the dictionary to the file
@save file_path_save_Data_dict Data_dict
