import ml_collections


def d(**kwargs):
    """Helper of creating a config dict."""
    return ml_collections.ConfigDict(initial_dictionary=kwargs)


def get_config():
    config = ml_collections.ConfigDict()
    config.model_path = ""
    config.classifier_path = ""
    config.imagenet_path = "/raid/common/imagenet-raw/"
    config.val_path   = 'train'
    config.output_dir = 'sde_cond_tiger'

    config.seed = 1234

    config.net_diffusion = d(
        image_size=256,
        class_cond=True,
        learn_sigma=True,
        num_channels=256,
        num_res_blocks=2,
        in_channels=3,
        channel_mult='',
        num_heads=4,
        num_head_channels=64,
        num_heads_upsample=-1,
        attention_resolutions='32,16,8',
        dropout=0.0,
        diffusion_steps=1000,
        noise_schedule='linear',
        timestep_respacing='',
        use_kl=False,
        predict_xstart=False,
        rescale_timesteps=False,
        rescale_learned_sigmas=False,
        use_checkpoint=False,
        use_scale_shift_norm=True,
        resblock_updown=True,
        use_fp16=False,
        use_new_attention_order=False,
        num_classes=1000
    )

    config.classifier = d(
        image_size=256,
        classifier_use_fp16=False,
        classifier_width=128,
        classifier_depth=2,
        classifier_attention_resolutions="32,16,8",  # 16
        classifier_use_scale_shift_norm=True,  # False
        classifier_resblock_updown=True,  # False
        classifier_pool="attention",
        in_channels=3,
        out_channels=1000,
    )


    config.sample = d(
        algorithm='sde',
        classifier_scale=1.0,
        eta=1.0,
        source='291',
        target='292',
        batch_size = 20,
        clip_denoised=True,
    )

    return config
