from tool.eval_score import fid_l2_psnr_ssim
import os
import shutil
from PIL import Image
from pathlib import Path
import blobfile as bf
os.environ["CUDA_VISIBLE_DEVICES"] = '1'

def copy_imagenet_dataset(imagenet_dir,out_dir,length=50000):
    """
    Finds the validation images for the given classes from val_dir,
    and copies them over to ./experiments/imagenet for translation.
    "/raid/common/imagenet-raw/train"
    """
    image_file_list = os.listdir(imagenet_dir)

    for ans,images in enumerate(image_file_list[:length]):
        path = os.path.join(imagenet_dir, images)
        try:
            os.mkdir(out_dir)
        except:
            pass
        copy_path = os.path.join(out_dir, f"{ans + 1}.PNG")
        original_image = Image.open(path)
        resized_image = original_image.resize((256, 256), Image.ANTIALIAS)
        resized_image.save(copy_path)
        #shutil.copyfile(path, copy_path)

if __name__ == '__main__':
    task = 'cat2dog'

    if task == 'cat2dog':
        copy_imagenet_dataset(gt_path,output_dir,len(os.listdir(translate_path)))
        fid_l2_psnr_ssim(task, translate_path, source_path, output_dir)
