# GCORN - Graph Convolutional Networks With Orthogonal Weights Are More Robust

This repository is the official implementation of our paper "Graph Convolutional Networks With Orthogonal Weights Are More Robust"

## Requirements

Code is written in Python 3.6 and requires:

- PyTorch
- Torch Geometric
- NetworkX

## Datasets
For node classifiation, the used datasets are as follows:
- Cora
- CiteSeer
- PubMed
- CS

All these datasets are part of the torch_geometric datasets and are directly downloaded when running the code.

## Training and Evaluation

To train and evaluate the model in the paper, the user should specify the following :

- Dataset : The dataset to be used
- hidden_dimension: The hidden dimension used in the model
- learning rate and epochs
- Budget: The budget of the attack
- Type of the attack: we evaluate using Random Attack and the PGD attack.

To run a normal code of GCORN without attack for the default values with Cora dataset:

```bash
cd Robust_GCORN/
python main/run_gcorn.py --dataset Cora
```

The checkpoints are stored in the folder "checkpoints"

## Results reproduction
To reproduce the results in the paper that compare the GCN and the GCORN, use the following:

```bash
python main_attack.py --dataset Cora --budget 0.5 --attack random
```

## Empriprical evaluation : Estimation of Adv[f]
Implementation of the proposed probabilistic evaluation is made available in the code through the folder "Empirical_Eval".
To estimate the values of Adv[f] for different values of Sigm :  

```bash
cd Robust_GCORN/
python Empirical_Eval/adv_estimation.py --dataset Cora
```

The command above use the checkpoints previously saved from the training of GRON saved in the folder "Robust_GCORN/checkpoints"

## Reproduction
For all the details related to the code and the implementation, please refer to our paper.
