# Efficient Training of Multi-task Neural Solver with Multi-armed Bandits



## Installation
### Basic environment settings
Our code run perfectly on Ubuntu18.04, CUDA version 11.4 and python3.8. The basic environment settings are as follows:
``` Bash
Python=3.8
PyTorch=1.10.2
```

The bandit algorithm is implemented by the following repo:
```commandline
@misc{SMPyBandits,
    title =   {{SMPyBandits: an Open-Source Research Framework for Single and Multi-Players Multi-Arms Bandits (MAB) Algorithms in Python}},
    author =  {Lilian Besson},
    year =    {2018},
    url =     {https://github.com/SMPyBandits/SMPyBandits/},
    howpublished = {Online at: \url{github.com/SMPyBandits/SMPyBandits}},
    note =    {Code at https://github.com/SMPyBandits/SMPyBandits/, documentation at https://smpybandits.github.io/}
}
```
in 
```commandline
https://github.com/SMPyBandits/SMPyBandits
```
and you should clone it to the same directory with our code.

# How To Run

## You can run [get_results_tab2.py](get_results_tab2.py) to get the results in Table 2 in the paper.

## Training
```python
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python train.py --epochs 1000 --warm_start 1 --select_freq 12 --tsp 20 50 100  --cvrp 20 50 100  --op 20 50 100  --kp 50 100 200 --bandit_alg exp3 --task_description train12task_exp3_freq12
```
## Evaluation
You can download the pretrain model [here](https://drive.google.com/file/d/1MdLlDn1AWy2lUFB7QLhZ5roktqsT4BxH/view) and put it in the [result](result) folder, and download the dataset [here](https://drive.google.com/file/d/1bmh_TGKcdoTp4IAZiMUP4CP4TfnK7HbZ/view?usp=drive_link) and put the unzipped folder in the root directory of the codes. Then run the following command:
```python
CUDA_VISIBLE_DEVICES=0 python test.py --model_path ./result/'_train_TSP[20, 50, 100]-CVRP[20, 50, 100]-OP[20, 50, 100]-KP[50, 100, 200]_BanditAlg-exp3_unseen-_desc-train12task_exp3_freq12' --model_epoch 1000
```

