from .q_learner import QLearner
from .noise_q_learner import QLearner as NoiseQLearner
from .wcd_q_learner import QLearner as WcdQLearner
from .coma_learner import COMALearner
from .actor_critic_learner import ActorCriticLearner
from .qtran_learner import QLearner as Qtranlearner
from .ppo_learner import PPOLearner as PPOLearner
from .wcd_ppo_learner import PPOLearner as WcdPPOLearner

REGISTRY = {}

REGISTRY["q_learner"] = QLearner
REGISTRY["noise_q_learner"] = NoiseQLearner
REGISTRY["wcd_q_learner"] = WcdQLearner
REGISTRY["coma_learner"] = COMALearner
REGISTRY["actor_critic_learner"] = ActorCriticLearner
REGISTRY["qtran_learner"] = Qtranlearner
REGISTRY["ppo_learner"] = PPOLearner
REGISTRY["wcd_ppo_learner"] = WcdPPOLearner
