#include <bits/stdc++.h>
using namespace std;

const int N = 10005;

double a[N], low[N], high[N], mn[N];

pair<double, double> confidence_interval(int n, double *a) {
    double mean = 0, standard_deviation = 0;

    for (int i = 0; i < n; i++)
        mean += a[i];
    mean /= n;

    for (int i = 0; i < n; i++)
        standard_deviation += (a[i] - mean) * (a[i] - mean);
    standard_deviation /= n;

    return make_pair(mean, 2.576 * standard_deviation / sqrt(n));
}

int main() {
    int K = 20000, m = 50, n = 400;

    char file_name[100];
    file_name[0] = '\0';
    strcat(file_name, "data/full-degenerate0.txt");

    for (int t = 0; t < 6; t++) {
        freopen(file_name, "r", stdin);

        int T; scanf("T = %d\n", &T);
        for (int i = 0; i < m; i++) {
            double sum = 0;
            for (int j = 0; j < n; j++) {
                double x;
                scanf("%lf", &x);
                sum += x;
            }
            a[i] = sum / n;
        }

        pair<double, double> w = confidence_interval(m, a);
        mn[t] = w.first;
        low[t] = w.first - w.second;
        high[t] = w.first + w.second;

        fclose(stdin);
        file_name[20]++;
    }

    for (int i = 0; i < 6; i++)
        printf("%lf, ", mn[i]);
    puts("");
    for (int i = 0; i < 6; i++)
        printf("%lf, ", low[i]);
    puts("");
    for (int i = 0; i < 6; i++)
        printf("%lf, ", high[i]);
    puts("");

    return 0;
}