
## 💪 Getting Started

### 🚀 Installation


```bash

# note that we use A100 with cu121

uv venv
source .venv/bin/activate
uv pip install -e .

```

### 📦  Starting Point

- try the OpenRouter API with free gpt-os-20b access 
```bash
vi .env # edit the .env and put a openrouter key 
python inference_api.py
```

- run the first method `Structural CoT Bypass`
```bash
python examples/1_cot_bypass.py one_example
```

- run the second method `Fake Over-Refusal`
```bash
python examples/2_fake_overrefusal.py one_example
```

- run the third method `Coercive Optimization`
```bash
python example/3_gcg.py
```

- run the forth method `Reasoning Hijack`

```bash
python examples/4_reasoning_hijack.py one_example
```

## 🧑‍💻 More Scripts

- Evaluate Structural CoT Bypass on StrongReject or HarmfulBehaviors 
```bash
 python examples/1_cot_bypass.py main --dataset_name=StrongReject
 python examples/1_cot_bypass.py main --dataset_name=HarmfulBehaviors
```


## 📂 Folder Structure 

├── examples # example scripts to run each method
│  ├── 1_cot_bypass.py
│  ├── 2_fake_overrefusal.py
│  ├── 3_gcg.py
│  ├── 4_reasoning_hijack.py
├── src
│  └── breakoss
│      ├── api.py
│      ├── cli.py
│      ├── datasets # dataset loaders
│      ├── evaluators # evaluation implementations
│      ├── go_jailbreak.py
│      ├── __init__.py
│      ├── __main__.py
│      ├── methods # method implementations
│      ├── models # model wrappers
│      ├── __pycache__
│      ├── py.typed
│      ├── utils.py
│      └── version.py
│  └── breakoss
├── tests # tests for the package
├── tox.ini
└── uv.lock
