c0=[0;0.2];
c0_dot=[0;0];
m=2;
g=-9.8;
mu=0.5;

Delta_t=0.02;
num_exper=20;
iteration=50;
T=T_total/Delta_t;
L=zeros(iteration*(T+3),num_exper);

min_eig=zeros(num_exper,1);

for exper_i=1:num_exper
    T_total=1;
    T=T_total/Delta_t;
    L_max=0.2;
    H_max=0.25;
    H_min=0.15;
    
    D_min=-0.1;
    D_max=0.1;
    M_min=10;
    M_max=20;

    
    %randomly generate r_x
    
    rx=zeros(T+1,1);
    rx0=0; 
    rx(1)=rx0;
    change=0;
    M=randi([M_min,M_max]);
    i0=M+1;
    for i=2:T+1
        if i==i0
            change=1;
        end
        if change==1
            D=D_min+(D_max-D_min)*rand;
            rx(i)=rx(i-1)+D;
            change=0;
            M=randi([M_min,M_max]);
            i0=i+M;
        else
            rx(i)=rx(i-1);
        end
    end
    
    % set rz to be 0
    
    rz=zeros(T+1,1);
    
    
    
    %solve bound for fx and fz based on space constraint by Chebyshev ball
    
    mat_f=zeros(7*(T-1)+2,2*(T-1)+2);
    
    mu_vec=zeros(T-1:1);
    for i=1:T-1
        mu_vec(i)=1;
    end
    
    for i=1:T-1
        for j=1:i
            mat_f(i,j)=(i-j+1)*(delta_t)^2/m;
            mat_f(i,2*(T-1)+1)=mat_f(i,2*(T-1)+1)+abs(mat_f(i,j));
        end
    end
    
    for i=T:2*(T-1)
        for j=1:i-T+1
            mat_f(i,j)=-(i-j+2-T)*(delta_t)^2/m;
            mat_f(i,2*(T-1)+1)=mat_f(i,2*(T-1)+1)+abs(mat_f(i,j));
        end
    end
    
    mat_f(2*(T-1)+1:3*(T-1),T:2*(T-1))=mat_f(1:T-1,1:T-1);
    mat_f(2*(T-1)+1:3*(T-1),2*(T-1)+2)=mat_f(1:T-1,2*(T-1)+1);
    
    mat_f(3*(T-1)+1:4*(T-1),T:2*(T-1))=mat_f(T:2*(T-1),1:T-1);
    mat_f(3*(T-1)+1:4*(T-1),2*(T-1)+2)=mat_f(T:2*(T-1),2*(T-1)+1);
    
    mat_f(4*(T-1)+1:5*(T-1),1:T-1)=eye(T-1);
    mat_f(4*(T-1)+1:5*(T-1),T:2*(T-1))=-mu*eye(T-1);
    mat_f(4*(T-1)+1:5*(T-1),2*(T-1)+1)=mu_vec;
    mat_f(4*(T-1)+1:5*(T-1),2*(T-1)+2)=mu*mu_vec;
    
    mat_f(5*(T-1)+1:6*(T-1),1:T-1)=-eye(T-1);
    mat_f(5*(T-1)+1:6*(T-1),T:2*(T-1))=-mu*eye(T-1);
    mat_f(5*(T-1)+1:6*(T-1),2*(T-1)+1)=mu_vec;
    mat_f(5*(T-1)+1:6*(T-1),2*(T-1)+2)=mu*mu_vec;
    
    mat_f(6*(T-1)+1:7*(T-1),T:2*(T-1))=-eye(T-1);
    
    mat_f(7*(T-1)+1,2*(T-1)+1)=-1;
    mat_f(7*(T-1)+2,2*(T-1)+2)=-1;
    
    
    
    
    b_fx_max=zeros(T-1,1);
    b_fx_min=zeros(T-1,1);
    
    b_fz_max=zeros(T-1,1);
    b_fz_min=zeros(T-1,1);
    
    for i=1:T-1
        b_fz_max(i)=H_max+rz(i+2)-c0(2)-(i+1)*c0_dot(2)*delta_t-(i+1)*i/2*g*(delta_t)^2;
        b_fz_min(i)=-(H_min+rz(i+2)-c0(2)-(i+1)*c0_dot(2)*delta_t-(i+1)*i/2*g*(delta_t)^2);
    end
    
    for i=1:T-1
        b_fx_max(i)=L_max+rx(i+2)-c0(1)-(i+1)*c0_dot(1)*delta_t;
        b_fx_min(i)=-(-L_max+rx(i+2)-c0(1)-(i+1)*c0_dot(1)*delta_t);
    end
    
    vec_f=[b_fx_max;b_fx_min;b_fz_max;b_fz_min;zeros(3*(T-1)+2,1)];
    
    f=zeros(2*(T-1)+2,1);
    f(2*(T-1)+1)=-0.001;
    f(2*(T-1)+2)=-1;
    
    x=linprog(f,mat_f,vec_f);
    
    
    fxc=x(1:T-1);
    fzc=x(T:2*(T-1));
    
    delta_fx=x(2*(T-1)+1);
    delta_fz=x(2*(T-1)+2);
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    % mat_f=zeros(8*(T-1),4*(T-1));
    % 
    % mu_vec=zeros(T-1:1);
    % for i=1:T-1
    %     mu_vec(i)=1;
    % end
    % 
    % for i=1:T-1
    %     for j=1:i
    %         mat_f(i,j)=(i-j+1)*(delta_t)^2/m;
    %     end
    % end
    % 
    % mat_f(1:T-1,2*(T-1)+1:3*(T-1))=abs(mat_f(1:T-1,1:T-1));
    % 
    % 
    % for i=T:2*(T-1)
    %     for j=1:i-T+1
    %         mat_f(i,j)=-(i-j+2-T)*(delta_t)^2/m;
    %     end
    % end
    % 
    % mat_f(T:2*(T-1),2*(T-1)+1:3*(T-1))=abs(mat_f(T:2*(T-1),1:T-1));
    % 
    % mat_f(2*(T-1)+1:3*(T-1),T:2*(T-1))=mat_f(1:T-1,1:T-1);
    % mat_f(2*(T-1)+1:3*(T-1),3*(T-1)+1:4*(T-1))=abs(mat_f(2*(T-1)+1:3*(T-1),T:2*(T-1)));
    % 
    % mat_f(3*(T-1)+1:4*(T-1),T:2*(T-1))=mat_f(T:2*(T-1),1:T-1);
    % mat_f(3*(T-1)+1:4*(T-1),3*(T-1)+1:4*(T-1))=abs(mat_f(3*(T-1)+1:4*(T-1),T:2*(T-1)));
    % 
    % mat_f(4*(T-1)+1:5*(T-1),1:T-1)=eye(T-1);
    % mat_f(4*(T-1)+1:5*(T-1),T:2*(T-1))=-mu*eye(T-1);
    % mat_f(4*(T-1)+1:5*(T-1),2*(T-1)+1:4*(T-1))=abs(mat_f(4*(T-1)+1:5*(T-1),1:2*(T-1)));
    % 
    % mat_f(5*(T-1)+1:6*(T-1),1:T-1)=-eye(T-1);
    % mat_f(5*(T-1)+1:6*(T-1),T:2*(T-1))=-mu*eye(T-1);
    % mat_f(5*(T-1)+1:6*(T-1),2*(T-1)+1:4*(T-1))=abs(mat_f(5*(T-1)+1:6*(T-1),1:2*(T-1)));
    % 
    % 
    % mat_f(6*(T-1)+1:8*(T-1),2*(T-1)+1:4*(T-1))=-eye(2*(T-1));
    % 
    % 
    % vec_f=[b_fx_max;b_fx_min;b_fz_max;b_fz_min;zeros(2*(T-1),1);-delta_fx*ones((T-1),1)/2;-delta_fz*ones((T-1),1)/2];
    % 
    % f=zeros(4*(T-1),1);
    % f(2*(T-1)+1:4*(T-1))=-1;
    % 
    % 
    % x=linprog(f,mat_f,vec_f);
    % 
    % 
    % fxc=x(1:T-1);
    % fzc=x(T:2*(T-1));
    % 
    % delta_fx=x(2*(T-1)+1:3*(T-1));
    % delta_fz=x(3*(T-1)+1:4*(T-1));
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    
    
    fx_min=fxc-delta_fx;
    fx_max=fxc+delta_fx;
    fz_min=fzc-delta_fz;
    fz_max=fzc+delta_fz;
    
    
    %calculate objective function  
    
    mu_c=1;
    mu_k=100;
    mu_f=1;
    
    R=zeros(2*(T+1),2*(T+1));
    for i=1:T-1
        for t=i+1:T
            R(2*i-1,2*i-1)=R(2*i-1,2*i-1)+mu_c*(delta_t)^4/(m^2)*(t-i)^2;
            R(2*i,2*i)=R(2*i,2*i)+mu_c*(delta_t)^4/(m^2)*(t-i)^2;
        end
        for j=i+1:T-1
            for t=j+1:T
                R(2*i-1,2*j-1)=R(2*i-1,2*j-1)+2*mu_c*(t-i)*(t-j)*(delta_t)^4/(m^2);
                R(2*i,2*j)=R(2*i,2*j)+2*mu_c*(t-i)*(t-j)*(delta_t)^4/(m^2);
            end
        end
    end
    
    R=(R+R')/2;
    
    R=R+mu_f*eye(2*(T+1));
    min_eig(exper_i)=max(eig(R));
    
    D=zeros(2*(T+1),1);
    for i=1:T-1
        for t=i+1:T
            D(2*i-1)=D(2*i-1)+mu_c*(c0(1)+c0_dot(1)*t*delta_t)*(t-i)*(delta_t)^2/m;
            D(2*i)=D(2*i)+mu_c*(c0(2)+c0_dot(2)*t*delta_t+t*(t-1)*g*(delta_t)^2/2-0.2)*(t-i)*(delta_t)^2/m;
        end
    end
    
    %apply ADMM
    
    
    f=zeros(2*(T+1),1);
    
    for i=1:2:2*(T-1)
        f(i)=x((i+1)/2);
        f(i+1)=x((i+1)/2+(T-1));
    end
    
    
    for i = 0:T
        eval(['C', num2str(i), '=', 'zeros(2*(T+1),2*(T+1))', ';']);
        if i>=2
            for j=1:i-1
                eval(['C', num2str(i), '(2*j-1,2*(i+1))','=', '(i-j)*(delta_t)^3/m', ';']);
                eval(['C', num2str(i), '(2*(i+1),2*j-1)','=', '(i-j)*(delta_t)^3/m', ';']);
                eval(['C', num2str(i), '(2*j,2*(i+1)-1)','=', '-(i-j)*(delta_t)^3/m', ';']);
                eval(['C', num2str(i), '(2*(i+1)-1,2*j)','=', '-(i-j)*(delta_t)^3/m', ';']);
            end
        end
    end
    
    d=zeros(2*(T+1),T+1);
    
    for i=0:T
         eval(['d', num2str(i), '=', 'zeros(2*(T+1),1)', ';']);
         if i==0
            eval(['d', num2str(i), '(2*i+1)' ,'=', '(rz(i+1)-c0(2))*delta_t', ';']); 
            eval(['d', num2str(i), '(2*i+2)' ,'=', '-(rx(i+1)-c0(1))*delta_t', ';']); 
         elseif i==1
             eval(['d', num2str(i), '(2*i+1)' ,'=', '(rz(i+1)-c0(2)-c0_dot(2)*i*delta_t)*delta_t', ';']);
             eval(['d', num2str(i), '(2*i+2)' ,'=', '-(rx(i+1)-c0(1)-c0_dot(1)*i*delta_t)*delta_t', ';']);
         else
            eval(['d', num2str(i), '(2*i+1)' ,'=', '(rz(i+1)-c0(2)-c0_dot(2)*i*delta_t-(i)*(i-1)/2*g*(delta_t)^2)*delta_t', ';']);
            eval(['d', num2str(i), '(2*i+2)' ,'=', '-(rx(i+1)-c0(1)-c0_dot(1)*i*delta_t)*delta_t', ';']);
         end
         eval(['d', '(:,i+1)' ,'=', 'd', num2str(i),';']);
    end
    
    
    
    
    w=zeros(T+1,1);
    
    Q=zeros(T+1,T+1);
    k=zeros(T+1,1);
    
    % for i=0:T
    %     if i<T
    %     Q(i+1,i+1)=1;
    %     Q(i+1,i+2)=-1;
    %     end
    %     Q(T+1,:)=ones(T+1,1);
    % end
    Q=eye(T+1);
    iteration=50;
    L_diff=zeros(iteration*(T+2),1);
    
    % L=zeros(iteration*(T+3),1);
    rho=300;
    Aef=[1,0;-1,0;0,1;0,-1];
    l=1;
    t1=clock;
    constraint=zeros(iteration,1);
    % options = optimoptions('quadprog',...
    %     'OptimalityTolerance', 1e-10, ...
    %     'ConstraintTolerance', 1e-10); 
    for t=1:iteration
        for i=0:T
            adi=setdiff(1:2*(T+1),[2*i+1,2*i+2]);
            P=zeros(2*(T+1),T+1);
            nabla_Ai=zeros(2,2);
            for j=0:T
                P(:,j+1)=eval(['C', num2str(j), '*f']);
                nabla_Ai=nabla_Ai+rho*((P(2*i+1:2*i+2,j+1)+d(2*i+1:2*i+2,j+1))*(P(2*i+1:2*i+2,j+1)+d(2*i+1:2*i+2,j+1))');
            end
            A=R(2*i+1:2*i+2,2*i+1:2*i+2)+nabla_Ai;
    
            b=(P(2*i+1:2*i+2,:)+d(2*i+1:2*i+2,:))*w;
    
            b=b+R(2*i+1:2*i+2,adi)*f(adi);
    
            b=b+D(2*i+1:2*i+2);
    
            for j=0:T
                c=P(2*i+1:2*i+2,j+1)+d(2*i+1:2*i+2,j+1);
                s=eval(['C', num2str(j), '(:,adi)','*f(adi)']);
                v=s(adi)/2+d(adi,j+1);
                c=f(adi)'*v*c;
                c=c+Q(j+1,:)*k*(P(2*i+1:2*i+2,j+1)+d(2*i+1:2*i+2,j+1));
                c=rho*c;
                b=b+c;
            end
            f_pre=-inv(A)*b;
    
            if i<=T-2
                bef=[fx_max(i+1);-fx_min(i+1);fz_max(i+1);-fz_min(i+1)];
                f(2*i+1:2*i+2)=quadprog(A,b,Aef,bef);
                %f(2*i+1:2*i+2)=quadprog(A,b,Aef,bef,[],[],[],[],[],options);
            else
                f(2*i+1:2*i+2)=project_cone(f_pre,mu);
            end
            for j=0:T
                P(:,j+1)=eval(['C', num2str(j), '*f']);
            end
            Af=(P'/2+d')*f;
            L(l,exper_i)=f'*R*f/2+D'*f+mu_k*(k'*k)/2+w'*(Af+Q*k)+rho*(Af+Q*k)'*(Af+Q*k)/2;
            l=l+1;
        end
        Af=(P'/2+d')*f;
        k=-inv(mu_k*eye(T+1)+rho*(Q'*Q))*Q'*(w+rho*Af);
        L(l,exper_i)=f'*R*f/2+D'*f+mu_k*(k'*k)/2+w'*(Af+Q*k)+rho*(Af+Q*k)'*(Af+Q*k)/2;
        l=l+1;
        w=w+rho*(Af+Q*k);
        L(l,exper_i)=f'*R*f/2+D'*f+mu_k*(k'*k)/2+w'*(Af+Q*k)+rho*(Af+Q*k)'*(Af+Q*k)/2;
        l=l+1;
        constraint(t)=(Af+Q*k)'*(Af+Q*k);
    end
    t2=clock;
end

for i=1:exper_i
    plot(0:6,L(1:T+3:7*(T+3),i)-L(iteration*(T+3),i));
    hold on
end
% % p=plot(dataset+10e-10);
% % p=plot(L(1:T+3:10*(T+3))-L(iteration*(T+3)));
% % p.LineWidth=2;
set(gca, 'YScale', 'log')
xlabel('#Iterations k')
ylabel('$$L^k-L^\star$$','Interpreter','latex')

% plot(constraint)
% set(gca, 'YScale', 'log')
center_z=zeros(T+1,1);
center_z(1)=c0(2);
center_zdot=c0_dot(2);
for i=0:T
    if i==0
        center_z(i+1)=center_z(1)+center_zdot*delta_t;
    else
        center_z(i+1)=center_z(1)+center_zdot*delta_t*(i+1)+i*(i+1)/2*g*(delta_t)^2;
        for j=0:i-1
            center_z(i+1)=center_z(i+1)+(i-j)*f(2*j+2)/m*(delta_t)^2;
        end
    end   
end

center_x=zeros(T+1,1);
center_x(1)=c0(1);
center_xdot=c0_dot(1);
for i=0:T
    if i==0
        center_x(i+1)=center_x(1)+center_xdot*delta_t;
    else
        center_x(i+1)=center_x(1)+center_xdot*delta_t*(i+1);
        for j=0:i-1
            center_x(i+1)=center_x(i+1)+(i-j)*f(2*j+1)/m*(delta_t)^2;
        end
    end   
end


function f=project_cone(fp,mu)
    if mu*fp(1)<=-fp(2) ||  fp(2)<0
        f=[0;0];
    elseif mu*fp(1)>fp(2)
        beta=(mu^2*fp(1)+mu*fp(2))/((mu^2+1)*fp(1));
        gamma=(mu*fp(1)+fp(2))/(mu^2+1);
        f=[beta*fp(1);gamma*fp(2)];
    else
        f=fp;
    end
end



























