import os
import json
import ipdb

cwd = os.getcwd()
exp1_questions_path = os.path.join(cwd, "dataset/exp1_question.jsonl")
exp1_question_answers_path = os.path.join(cwd, "dataset/exp1_question_answer.jsonl")
exp2_answer_reasons_path = os.path.join(cwd, "dataset/exp2_answer_reason.jsonl")

def change_str_to_json(raw_data_list):
    data_list = []
    for ele in raw_data_list:
        data_list.append(json.loads(ele))
    return data_list

def integrate_datas(exp1_q, exp1_qa, exp2_ar):
    datasets = []
    for i in range(len(exp1_q)):
        temp_data_element = exp1_q[i]
        temp_data_element['answers'] = []
        temp_data_element['answer_reasons'] = {}
        for _ in range(i * 10, i * 10 + 10):
            temp_data_element['answers'].append({'value': exp1_qa[_]['value'], 'answer': exp1_qa[_]['response']})
            # temp_data_element['answer_reasons'].append({'value': exp1_qa[_]['value'], 'reason': exp2_ar[_]['summary']})
            temp_data_element['answer_reasons'][exp1_qa[_]['value']] = exp2_ar[_]['summary']
        datasets.append(temp_data_element)
    return datasets

def data_loader(
        exp1_q_path = exp1_questions_path,
        exp1_qa_path = exp1_question_answers_path,
        exp2_ar_path = exp2_answer_reasons_path
    ):
    with open(exp1_q_path, "r", encoding='utf-8') as f:
        exp1_q = f.readlines()

    with open(exp1_qa_path, "r", encoding='utf-8') as f:
        exp1_qa = f.readlines()

    with open(exp2_ar_path, "r", encoding='utf-8') as f:
        exp2_ar = f.readlines()

    return integrate_datas(change_str_to_json(exp1_q), change_str_to_json(exp1_qa), change_str_to_json(exp2_ar))



# if __name__ == '__main__':
#     datasets = data_loader()
#     ipdb.set_trace()
