
def is_short_sentence_in_long_sentence(short_sentence_, long_sentence_):
    if not isinstance(short_sentence_, str) or not isinstance(long_sentence_, str):
        raise ValueError("Input must be string")

    raw_short_sentences = short_sentence_.lower().split('.')
    short_sentences = []
    long_sentence = long_sentence_.lower()
    for short_sentence in raw_short_sentences:
        tmp_sentence = ''.join(e for e in short_sentence if e.isalnum())
        tmp_sentence = tmp_sentence.strip()
        if tmp_sentence != '':
            short_sentences.append(tmp_sentence)
    long_sentence = ''.join(e for e in long_sentence if e.isalnum())

    for short_sentence in short_sentences:
        if short_sentence in long_sentence:
            return True
    return False
